/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.file;

import java.util.Comparator;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectRenamedEvent;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;

@ApplicationScoped
public class PlannerDataModelerHelperUtils {
    private static final Logger logger = LoggerFactory.getLogger(PlannerDataModelerHelperUtils.class);
    private IOService ioService;
    private ComparatorDefinitionService comparatorDefinitionService;
    private DataModelerService dataModelerService;

    public PlannerDataModelerHelperUtils() {
    }

    @Inject
    public PlannerDataModelerHelperUtils(@Named(value="ioStrategy") IOService ioService, ComparatorDefinitionService comparatorDefinitionService, DataModelerService dataModelerService) {
        this.ioService = ioService;
        this.comparatorDefinitionService = comparatorDefinitionService;
        this.dataModelerService = dataModelerService;
    }

    public void updateDataObject(Path dataObjectPath) {
        String dataObjectString = this.ioService.readAllString(Paths.convert((Path)dataObjectPath));
        GenerationResult generationResult = this.dataModelerService.loadDataObject(dataObjectPath, dataObjectString, dataObjectPath);
        DataObject dataObject = generationResult.getDataObject();
        if (dataObject != null && (generationResult.getErrors() == null || generationResult.getErrors().isEmpty())) {
            JavaClass comparatorObject = this.getComparatorObject(dataObject);
            if (comparatorObject != null) {
                JavaClass updatedComparatorObject = this.comparatorDefinitionService.updateComparatorObject(dataObject, comparatorObject);
                dataObject.removeNestedClass(comparatorObject);
                dataObject.addNestedClass(updatedComparatorObject);
                Annotation planningEntityAnnotation = dataObject.getAnnotation(PlanningEntity.class.getName());
                if (planningEntityAnnotation != null) {
                    planningEntityAnnotation.setValue("difficultyComparatorClass", (Object)(dataObject.getName() + ".DifficultyComparator"));
                }
                if ((generationResult = this.dataModelerService.updateSource(dataObjectString, dataObjectPath, dataObject)).getDataObject() != null && generationResult.getErrors() == null || generationResult.getErrors().isEmpty()) {
                    this.ioService.write(Paths.convert((Path)dataObjectPath), generationResult.getSource(), new OpenOption[0]);
                } else {
                    logger.error("Data object " + dataObject.getClassName() + " couldn't be updated, path: " + dataObjectPath + ".");
                }
            }
        } else {
            logger.error("Data object couldn't be loaded, path: " + dataObjectPath + ".");
        }
    }

    private void onDataObjectRename(@Observes DataObjectRenamedEvent event) {
        Path updatedPath = event.getPath();
        if (updatedPath != null) {
            try {
                this.updateDataObject(updatedPath);
            }
            catch (Exception e) {
                logger.error("Data object couldn't be updated, path: " + updatedPath + ".");
            }
        }
    }

    private JavaClass getComparatorObject(DataObject dataObject) {
        String difficultyComparatorClass;
        Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
        if (dataObject.getNestedClasses() != null && planningEntityAnnotation != null && (difficultyComparatorClass = (String)planningEntityAnnotation.getValue("difficultyComparatorClass")) != null && difficultyComparatorClass.matches("\\w[\\.\\w]+\\.class")) {
            String[] difficultyComparatorTokens = difficultyComparatorClass.split("\\.");
            Optional<JavaClass> comparatorNestedClass = dataObject.getNestedClasses().stream().filter(t -> t.getName().equals(difficultyComparatorTokens[difficultyComparatorTokens.length - 2]) && t.getAnnotation(ComparatorDefinition.class.getName()) != null && t.getAnnotation("javax.annotation.Generated") != null && t.getInterfaces().stream().anyMatch(i -> i.startsWith(Comparator.class.getName()))).findFirst();
            if (comparatorNestedClass.isPresent()) {
                return comparatorNestedClass.get();
            }
        }
        return null;
    }
}

