/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.file;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.optaplanner.workbench.screens.domaineditor.backend.server.file.PlannerDataModelerHelperUtils;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@RunWith(value=MockitoJUnitRunner.class)
public class PlannerDataModelerHelperUtilsTest {
    @Mock
    private IOService ioService;
    @Mock
    private ComparatorDefinitionService comparatorDefinitionService;
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private Path dataObjectPath;
    private PlannerDataModelerHelperUtils plannerDataModelerHelperUtils;
    private GenerationResult generationResult;

    @Before
    public void setUp() {
        this.plannerDataModelerHelperUtils = new PlannerDataModelerHelperUtils(this.ioService, this.comparatorDefinitionService, this.dataModelerService);
        this.generationResult = new GenerationResult();
        String pathString = "test source";
        Mockito.when((Object)this.dataObjectPath.toURI()).thenReturn((Object)"file:///dataObjects/Test.java");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)this.dataObjectPath))).thenReturn((Object)"test source");
        Mockito.when((Object)this.dataModelerService.loadDataObject(this.dataObjectPath, "test source", this.dataObjectPath)).thenReturn((Object)this.generationResult);
    }

    @Test
    public void generationResultHasErrors() {
        this.generationResult.setErrors(Collections.singletonList(Mockito.mock(DataModelerError.class)));
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        this.generationResult.setDataObject(dataObject);
        this.plannerDataModelerHelperUtils.updateDataObject(this.dataObjectPath);
        ((DataObject)Mockito.verify((Object)dataObject, (VerificationMode)Mockito.never())).getAnnotation((String)Matchers.any());
    }

    @Test
    public void dataObjectIsNull() {
        this.generationResult.setDataObject(null);
        this.plannerDataModelerHelperUtils.updateDataObject(this.dataObjectPath);
    }

    @Test
    public void generationResultErrorsIsNull() {
        this.generationResult.setErrors(null);
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        this.generationResult.setDataObject(dataObject);
        this.plannerDataModelerHelperUtils.updateDataObject(this.dataObjectPath);
        ((DataObject)Mockito.verify((Object)dataObject)).getAnnotation((String)Matchers.any());
    }

    @Test
    public void generationResultErrorsIsEmpty() {
        this.generationResult.setErrors(Collections.emptyList());
        DataObject dataObject = (DataObject)Mockito.mock(DataObject.class);
        this.generationResult.setDataObject(dataObject);
        this.plannerDataModelerHelperUtils.updateDataObject(this.dataObjectPath);
        ((DataObject)Mockito.verify((Object)dataObject)).getAnnotation((String)Matchers.any());
    }
}

