/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Collection;
import java.util.Collections;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.PlanningSolutionCopyValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionCopyValidatorTest {
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private IOService ioService;
    @Mock
    private org.uberfire.backend.vfs.Path dataObjectPath;
    private PlanningSolutionCopyValidator copyValidator;

    @Before
    public void setUp() {
        this.copyValidator = new PlanningSolutionCopyValidator(this.dataModelerService, this.ioService);
        Mockito.when((Object)this.dataObjectPath.toURI()).thenReturn((Object)"file:///project/Test.java");
        Mockito.when((Object)this.dataObjectPath.getFileName()).thenReturn((Object)"Test.java");
        Mockito.when((Object)this.ioService.readAllString((Path)Matchers.any(Path.class))).thenReturn((Object)"");
    }

    @Test
    public void accept() {
        Assert.assertTrue((boolean)this.copyValidator.accept(this.dataObjectPath));
        org.uberfire.backend.vfs.Path propertiesPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)propertiesPath.getFileName()).thenReturn((Object)"Test.properties");
        Assert.assertFalse((boolean)this.copyValidator.accept(propertiesPath));
    }

    @Test
    public void checkDataObjectIsNotAPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        Collection result = this.copyValidator.validate(this.dataObjectPath, (DataObject)dataObject);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void checkDataObjectIsAPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        Collection result = this.copyValidator.validate(this.dataObjectPath, (DataObject)dataObject);
        Assert.assertEquals((long)1L, (long)result.size());
        ValidationMessage message = (ValidationMessage)result.iterator().next();
        Assert.assertTrue((boolean)(message instanceof PlanningSolutionToBeDuplicatedMessage));
    }

    @Test
    public void checkDataObjectIsNull() {
        Collection result = this.copyValidator.validate(this.dataObjectPath, null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void pathValidation_dataObjectPathIsPassedToIoService() {
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)new GenerationResult());
        this.copyValidator.validate(this.dataObjectPath);
        ((IOService)Mockito.verify((Object)this.ioService)).readAllString(Paths.convert((org.uberfire.backend.vfs.Path)this.dataObjectPath));
    }

    @Test
    public void pathValidation_pathIsNull() {
        Collection result = this.copyValidator.validate(null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void pathValidation_noMessagesWhenGenerationFails() {
        GenerationResult generationResult = new GenerationResult();
        generationResult.setErrors(Collections.singletonList(new DataModelerError()));
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        generationResult.setDataObject((DataObject)dataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Collection result = this.copyValidator.validate(this.dataObjectPath);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void pathValidation_dataObjectIsNull() {
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(null);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Collection result = this.copyValidator.validate(this.dataObjectPath);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void pathValidation_dataObjectIsNotPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)dataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Collection result = this.copyValidator.validate(this.dataObjectPath);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void pathValidation_dataObjectIsPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)dataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Collection result = this.copyValidator.validate(this.dataObjectPath);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.iterator().next() instanceof PlanningSolutionToBeDuplicatedMessage));
    }
}

