/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.helper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.DeleteHelper;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class PlanningSolutionDeleteHelper
implements DeleteHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanningSolutionDeleteHelper.class);
    private static final String SCORE_HOLDER_GLOBAL_FILE_SUFFIX = "ScoreHolderGlobal.gdrl";
    private IOService ioService;
    private DataModelerService dataModelerService;
    private KieModuleService kieModuleService;

    public PlanningSolutionDeleteHelper() {
    }

    @Inject
    public PlanningSolutionDeleteHelper(@Named(value="ioStrategy") IOService ioService, DataModelerService dataModelerService, KieModuleService kieModuleService) {
        this.ioService = ioService;
        this.dataModelerService = dataModelerService;
        this.kieModuleService = kieModuleService;
    }

    public boolean supports(org.uberfire.backend.vfs.Path path) {
        return path.getFileName().endsWith(".java");
    }

    public void postProcess(org.uberfire.backend.vfs.Path path) {
        String dataObjectSource = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
        GenerationResult generationResult = this.dataModelerService.loadDataObject(path, dataObjectSource, path);
        if (generationResult.hasErrors()) {
            LOGGER.warn("Path " + path + " parsing as a data object has failed. Score holder global generation will be skipped.");
        } else {
            DataObject dataObject = generationResult.getDataObject();
            if (dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
                Path source = Paths.convert((org.uberfire.backend.vfs.Path)this.kieModuleService.resolvePackage(path).getPackageMainResourcesPath());
                Path sourcePackage = Files.isDirectory((Path)source, (LinkOption[])new LinkOption[0]) ? source : source.getParent();
                String dataObjectFileName = path.getFileName().substring(0, path.getFileName().indexOf("."));
                this.ioService.deleteIfExists(sourcePackage.resolve(dataObjectFileName + SCORE_HOLDER_GLOBAL_FILE_SUFFIX), new DeleteOption[0]);
            }
        }
    }
}

