/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend;

import java.util.Arrays;
import java.util.Collection;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScoreHolder;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.PlanningSolutionScoreHolderSaveValidator;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.ScoreHolderUtils;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeToBeChangedMessage;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionScoreHolderSaveValidatorTest {
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private AssetsUsageService assetsUsageService;
    @Mock
    private IOService ioService;
    @Mock
    private ScoreHolderUtils scoreHolderUtils;
    private PlanningSolutionScoreHolderSaveValidator validator;

    @Before
    public void setUp() {
        this.validator = new PlanningSolutionScoreHolderSaveValidator(this.dataModelerService, this.ioService, this.scoreHolderUtils, this.assetsUsageService);
    }

    @Test
    public void scoreTypeChanged() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObject originalDataObject = this.createDataObject(HardSoftScore.class);
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn(originalDataObject)).thenReturn((Object)HardSoftScore.class.getName());
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn(HardSoftScore.class.getName())).thenReturn((Object)HardSoftScoreHolder.class.getName());
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(HardSoftScoreHolder.class.getName(), ResourceType.JAVA, dataObjectPath)).thenReturn(Arrays.asList((Path)Mockito.mock(Path.class)));
        DataObject updatedDataObject = this.createDataObject(SimpleScore.class);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn(updatedDataObject)).thenReturn((Object)SimpleScore.class.getName());
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn(SimpleScore.class.getName())).thenReturn((Object)SimpleScoreHolder.class.getName());
        Collection result = this.validator.validate(dataObjectPath, updatedDataObject);
        Assert.assertEquals((long)1L, (long)result.size());
        ValidationMessage message = (ValidationMessage)result.iterator().next();
        Assert.assertTrue((boolean)(message instanceof ScoreHolderGlobalTypeToBeChangedMessage));
    }

    @Test
    public void dataObjectToAPlanningSolution() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObject originalDataObject = this.createDataObject(null);
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        DataObject updatedDataObject = this.createDataObject(SimpleScore.class);
        Collection result = this.validator.validate(dataObjectPath, updatedDataObject);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void dataObjectToADataObject() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObject originalDataObject = this.createDataObject(null);
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        DataObject updatedDataObject = this.createDataObject(null);
        Collection result = this.validator.validate(dataObjectPath, updatedDataObject);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void scoreHolderTypeNotRecognized() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObject originalDataObject = this.createDataObject(HardSoftScore.class);
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn(originalDataObject)).thenReturn((Object)HardSoftScore.class.getName());
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn(HardSoftScore.class.getName())).thenReturn((Object)HardSoftScoreHolder.class.getName());
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(HardSoftScoreHolder.class.getName(), ResourceType.JAVA, dataObjectPath)).thenReturn(Arrays.asList((Path)Mockito.mock(Path.class)));
        DataObject updatedDataObject = this.createDataObject(SimpleScore.class);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn(updatedDataObject)).thenReturn((Object)"UnknownScoreClassName");
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn("UnknownScoreClassName")).thenReturn(null);
    }

    private DataObject createDataObject(Class<? extends Score> scoreClass) {
        DataObjectImpl dataObject = new DataObjectImpl("test", "Test");
        if (scoreClass != null) {
            dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
            dataObject.addProperty("score", scoreClass.getName());
        }
        return dataObject;
    }
}

