/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.helper;

import org.guvnor.common.services.project.model.Package;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.workbench.screens.domaineditor.backend.server.helper.PlanningSolutionRenameWorkaroundHelper;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionRenameHelperTest {
    @Mock
    private IOService ioService;
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private KieModuleService kieModuleService;
    private PlanningSolutionRenameWorkaroundHelper renameHelper;

    @Before
    public void setUp() {
        this.renameHelper = new PlanningSolutionRenameWorkaroundHelper(this.ioService, this.dataModelerService, this.kieModuleService);
    }

    @Test
    public void postProcess() {
        org.uberfire.backend.vfs.Path sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        org.uberfire.backend.vfs.Path destinationPath = PathFactory.newPath((String)"TestDestination.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)sourcePath))).thenReturn((Object)"test source");
        DataObjectImpl dataObject = new DataObjectImpl("test", "TestSource");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)dataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Package _package = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)_package.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"dataObjects", (String)"file:///dataObjects"));
        Mockito.when((Object)this.kieModuleService.resolvePackage(sourcePath)).thenReturn((Object)_package);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any())).thenReturn((Object)true);
        this.renameHelper.postProcess(sourcePath, destinationPath);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).move((Path)Matchers.any(Path.class), (Path)Matchers.any(Path.class), new CopyOption[0]);
    }
}

