/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;

public class PlannerDataObjectEditor
extends ObjectEditor
implements PlannerDataObjectEditorView.Presenter {
    private PlannerDataObjectEditorView view;

    @Inject
    public PlannerDataObjectEditor(PlannerDataObjectEditorView view) {
        this.view = view;
        view.setPresenter(this);
        this.initWidget(view.asWidget());
    }

    public String getName() {
        return "PLANNER_OBJECT_EDITOR";
    }

    public String getDomainName() {
        return "PLANNER_DOMAIN";
    }

    protected void loadDataObject(DataObject dataObject) {
        this.clean();
        this.dataObject = dataObject;
        if (dataObject != null) {
            boolean hasPlanningEntity = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null;
            boolean hasPlanningSolution = dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null;
            this.view.setPlanningEntityValue(hasPlanningEntity);
            this.view.setPlanningSolutionValue(hasPlanningSolution);
            this.view.setNotInPlanningValue(!hasPlanningEntity && !hasPlanningSolution);
        }
    }

    public void clean() {
        this.view.clear();
        this.view.setNotInPlanningValue(true);
    }

    @Override
    public void onNotInPlanningChange(boolean value) {
        if (value && this.dataObject != null) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
        }
    }

    @Override
    public void onPlanningEntityChange(boolean value) {
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            }
        }
    }

    @Override
    public void onPlanningSolutionChange(boolean value) {
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
            }
        }
    }
}

