/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditor;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerEditorBaseTest;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlannerDataObjectEditorTest
extends PlannerEditorBaseTest {
    @Mock
    private PlannerDataObjectEditorView view;

    protected PlannerDataObjectEditor createObjectEditor() {
        PlannerDataObjectEditor objectEditor = new PlannerDataObjectEditor(this.view, this.handlerRegistry, this.dataModelerEvent, this.commandBuilder);
        return objectEditor;
    }

    @Test
    public void loadDataObjectTest() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningEntityValue(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionValue(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setNotInPlanningValue(true);
    }

    @Test
    public void changeToPlanningEntityTest() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.when((Object)this.view.getPlanningEntityValue()).thenReturn((Object)true);
        objectEditor.onPlanningEntityChange();
        DataObject dataObject = this.context.getDataObject();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getPlanningEntityValue();
        Assert.assertNotNull((Object)dataObject.getAnnotation(PlanningEntity.class.getName()));
    }

    @Test
    public void changeToPlanningSolutionTest() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.when((Object)this.view.getPlanningSolutionValue()).thenReturn((Object)true);
        objectEditor.onPlanningSolutionChange();
        DataObject dataObject = this.context.getDataObject();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getPlanningSolutionValue();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(true);
        Assert.assertNotNull((Object)dataObject.getAnnotation(PlanningSolution.class.getName()));
        Assert.assertEquals((Object)"org.optaplanner.core.impl.domain.solution.AbstractSolution<org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore>", (Object)dataObject.getSuperClassName());
    }
}

