/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.optaplanner.workbench.screens.domaineditor.client.util.PlannerDomainTypes;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.uberfire.commons.data.Pair;

@Dependent
public class PlannerDataObjectEditor
extends ObjectEditor
implements PlannerDataObjectEditorView.Presenter {
    private PlannerDataObjectEditorView view;

    @Inject
    public PlannerDataObjectEditor(PlannerDataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String getName() {
        return "PLANNER_OBJECT_EDITOR";
    }

    public String getDomainName() {
        return "PLANNER_DOMAIN";
    }

    public void onContextChange(DataModelerContext context) {
        super.onContextChange(context);
        this.adjustSelectedPlanningSolutionScoreType();
    }

    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.dataObject = dataObject;
        if (dataObject != null) {
            boolean hasPlanningEntity = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null;
            boolean hasPlanningSolution = dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null;
            this.view.setPlanningEntityValue(hasPlanningEntity);
            this.view.setPlanningSolutionValue(hasPlanningSolution);
            this.view.showPlanningSolutionScoreType(hasPlanningSolution);
            this.view.setNotInPlanningValue(!hasPlanningEntity && !hasPlanningSolution);
        }
    }

    public void clear() {
        this.view.clear();
        this.view.setNotInPlanningValue(true);
    }

    @Override
    public void onNotInPlanningChange() {
        boolean value = this.view.getNotInPlanningValue();
        if (value && this.dataObject != null) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
            if (this.isPlannerSolution(this.getDataObject().getSuperClassName())) {
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
            }
            this.view.showPlanningSolutionScoreType(false);
        }
    }

    @Override
    public void onPlanningEntityChange() {
        boolean value = this.view.getPlanningEntityValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                if (this.isPlannerSolution(this.getDataObject().getSuperClassName())) {
                    this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                }
                this.view.showPlanningSolutionScoreType(false);
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            }
        }
    }

    @Override
    public void onPlanningSolutionChange() {
        boolean value = this.view.getPlanningSolutionValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.buildPlanningSolutionScoreTypeSuperClass(this.getByDefaultSolutionScoreType())).execute();
                this.view.showPlanningSolutionScoreType(true);
                this.view.setPlanningSolutionScoreType(this.getByDefaultSolutionScoreType());
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                this.view.showPlanningSolutionScoreType(false);
            }
        }
    }

    @Override
    public void onPlanningSolutionScoreTypeChange() {
        String planningSolutionScoreType = this.view.getPlanningSolutionScoreType();
        String superClass = this.buildPlanningSolutionScoreTypeSuperClass(planningSolutionScoreType);
        if (superClass != null) {
            this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), superClass).execute();
        }
    }

    protected void onDataObjectChange(@Observes DataObjectChangeEvent event) {
        super.onDataObjectChange(event);
        if (event.isFromContext(this.getContext() != null ? this.getContext().getContextId() : null) && !event.isFrom(this.getName()) && event.getChangeType() == ChangeType.SUPER_CLASS_NAME_CHANGE && this.getDataObject() != null && this.getDataObject().getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null && !this.isPlannerSolution(this.getDataObject().getSuperClassName()) && this.isPlannerSolution(event.getOldValue() != null ? event.getOldValue().toString() : null)) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
        }
    }

    private boolean isPlannerSolution(String superClassName) {
        return superClassName != null && (superClassName.startsWith("org.optaplanner.core.impl.domain.solution.AbstractSolution") || superClassName.startsWith("AbstractSolution"));
    }

    private List<Pair<String, String>> getPlanningSolutionScoreTypeOptions() {
        return PlannerDomainTypes.SCORE_TYPES;
    }

    private String buildPlanningSolutionScoreTypeSuperClass(String planningSolutionScoreType) {
        return planningSolutionScoreType != null ? "org.optaplanner.core.impl.domain.solution.AbstractSolution<" + planningSolutionScoreType + ">" : null;
    }

    private void adjustSelectedPlanningSolutionScoreType() {
        if (this.context != null && this.context.getEditorModelContent() != null && this.context.getEditorModelContent().getSource() != null) {
            String selectedScoreType = this.getSelectedPlanningSolutionTypeFromSource(this.context.getEditorModelContent().getSource());
            if (selectedScoreType == null) {
                selectedScoreType = this.getByDefaultSolutionScoreType();
            }
            this.view.initPlanningSolutionScoreTypeOptions(this.getPlanningSolutionScoreTypeOptions(), selectedScoreType);
        }
    }

    private String getSelectedPlanningSolutionTypeFromSource(String source) {
        for (Pair<String, String> type : PlannerDomainTypes.SCORE_TYPES) {
            if (!source.contains("AbstractSolution<" + (String)type.getK1() + ">") && !source.contains("AbstractSolution<" + (String)type.getK2() + ">")) continue;
            return (String)type.getK2();
        }
        return null;
    }

    private String getByDefaultSolutionScoreType() {
        return "org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore";
    }
}

