/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.FieldEditor;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectFieldEditorView;

@Dependent
public class PlannerDataObjectFieldEditor
extends FieldEditor
implements PlannerDataObjectFieldEditorView.Presenter {
    private PlannerDataObjectFieldEditorView view;

    @Inject
    public PlannerDataObjectFieldEditor(PlannerDataObjectFieldEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String getName() {
        return "PLANNER_FIELD_EDITOR";
    }

    public String getDomainName() {
        return "PLANNER_DOMAIN";
    }

    protected void loadDataObjectField(DataObject dataObject, ObjectProperty objectField) {
        this.view.clear();
        this.view.showPlanningFieldPropertiesNotAvailable(true);
        this.dataObject = dataObject;
        this.objectField = objectField;
        if (dataObject != null && objectField != null) {
            this.loadPlanningSolution();
            this.loadPlanningEntitySettings();
        }
    }

    @Override
    public void onValueRangeProviderChange() {
        boolean isSet = this.view.getValueRangeProviderValue();
        if (isSet) {
            ArrayList<ValuePair> initialValue = new ArrayList<ValuePair>();
            initialValue.add(new ValuePair("id", (Object)""));
            this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.valuerange.ValueRangeProvider", initialValue).execute();
        } else {
            this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.valuerange.ValueRangeProvider").execute();
            this.view.setValueRangeProviderIdValue(null);
        }
        this.view.enableValueRangeProviderId(isSet);
    }

    @Override
    public void onValueRangeProviderIdChange() {
        String value = this.view.getValueRangeProviderIdValue();
        String string = value = value == null ? "" : value;
        if (this.getObjectField().getAnnotation("org.optaplanner.core.api.domain.valuerange.ValueRangeProvider") != null) {
            this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.valuerange.ValueRangeProvider", "id", (Object)value, false).execute();
        }
    }

    @Override
    public void onPlanningEntityCollectionChange() {
        boolean isSet = this.view.getPlanningEntityCollectionValue();
        if (isSet) {
            this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty").execute();
        } else {
            this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty").execute();
        }
    }

    @Override
    public void onPlanningVariableChange() {
        boolean isSet = this.view.getPlanningVariableValue();
        if (isSet) {
            this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.variable.PlanningVariable").execute();
        } else {
            this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.variable.PlanningVariable").execute();
            this.view.setValueRangeProviderRefsValue(null);
        }
        this.view.enableValueRangeProviderRefs(isSet);
    }

    @Override
    public void onValueRangeProviderRefsChange() {
        String textValue = this.view.getValueRangeProviderRefsValue();
        ArrayList<String> listValue = null;
        if (textValue != null && !"".equals(textValue)) {
            listValue = new ArrayList<String>();
            listValue.add(textValue);
        }
        if (this.getObjectField().getAnnotation("org.optaplanner.core.api.domain.variable.PlanningVariable") != null) {
            this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.optaplanner.core.api.domain.variable.PlanningVariable", "valueRangeProviderRefs", listValue, false).execute();
        }
    }

    public void clear() {
        this.view.clear();
    }

    private void loadPlanningEntitySettings() {
        if (this.dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null) {
            this.view.showPlanningEntitySettingsPanel(true);
            this.view.showPlanningFieldPropertiesNotAvailable(false);
            Annotation annotation = this.objectField.getAnnotation("org.optaplanner.core.api.domain.variable.PlanningVariable");
            if (annotation != null) {
                this.view.setPlanningVariableValue(true);
                this.view.enableValueRangeProviderRefs(true);
                List valueRangeProviderRefs = (List)annotation.getValue("valueRangeProviderRefs");
                if (valueRangeProviderRefs != null && valueRangeProviderRefs.size() > 0) {
                    String value = valueRangeProviderRefs.get(0) != null ? valueRangeProviderRefs.get(0).toString() : null;
                    this.view.setValueRangeProviderRefsValue(value);
                }
            } else {
                this.view.enableValueRangeProviderRefs(false);
            }
        }
    }

    private void loadPlanningSolution() {
        if (this.dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
            this.view.showPlanningSolutionSettingsPanel(true);
            this.view.showPlanningFieldPropertiesNotAvailable(false);
            Annotation annotation = this.objectField.getAnnotation("org.optaplanner.core.api.domain.valuerange.ValueRangeProvider");
            if (annotation != null) {
                this.view.setValueRangeProviderValue(true);
                this.view.enableValueRangeProviderId(true);
                String id = (String)annotation.getValue("id");
                this.view.setValueRangeProviderIdValue(id);
            } else {
                this.view.enableValueRangeProviderId(false);
            }
            annotation = this.objectField.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty");
            this.view.setPlanningEntityCollectionValue(annotation != null);
        }
    }
}

