/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.handlers.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ResourceOptions;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorObject;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.optaplanner.workbench.screens.domaineditor.service.PlannerDataObjectEditorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PlannerDomainHandler
implements DomainHandler {
    private static final Logger logger = LoggerFactory.getLogger(PlannerDomainHandler.class);
    @Inject
    private Caller<PlannerDataObjectEditorService> plannerDataObjectEditorService;

    public String getName() {
        return "PLANNER";
    }

    public int getPriority() {
        return 5;
    }

    public ResourceOptions getResourceOptions(boolean newInstance) {
        return null;
    }

    public void postCommandProcessing(DataModelCommand command) {
    }

    public void postEventProcessing(DataModelerEvent event) {
        try {
            final DataObject dataObject = event.getCurrentDataObject();
            if (dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null) {
                final Annotation comparatorDefinition = dataObject.getAnnotation(ComparatorDefinition.class.getName());
                if (comparatorDefinition == null) {
                    return;
                }
                if (dataObject.getNestedClasses() == null || dataObject.getNestedClasses().isEmpty()) {
                    return;
                }
                ComparatorObject comparatorObject = this.getComparatorNestedClass(dataObject);
                if (event instanceof DataObjectFieldDeletedEvent) {
                    boolean changed = false;
                    ListIterator objectPropertyPathListIterator = comparatorObject.getObjectPropertyPathList().listIterator();
                    while (objectPropertyPathListIterator.hasNext()) {
                        ObjectPropertyPath objectPropertyPath = (ObjectPropertyPath)objectPropertyPathListIterator.next();
                        ListIterator iterator = objectPropertyPath.getObjectPropertyPath().listIterator();
                        boolean remove = false;
                        while (iterator.hasNext()) {
                            ObjectProperty objectProperty = (ObjectProperty)iterator.next();
                            if (remove) {
                                iterator.remove();
                                continue;
                            }
                            if (!objectProperty.equals(event.getCurrentField())) continue;
                            iterator.remove();
                            remove = true;
                            changed = true;
                        }
                        if (!objectPropertyPath.getObjectPropertyPath().isEmpty()) continue;
                        objectPropertyPathListIterator.remove();
                    }
                    if (changed) {
                        ((PlannerDataObjectEditorService)this.plannerDataObjectEditorService.call((RemoteCallback)new RemoteCallback<ComparatorObject>(){

                            public void callback(ComparatorObject updatedComparatorObject) {
                                dataObject.getNestedClasses().clear();
                                if (updatedComparatorObject != null) {
                                    dataObject.addNestedClass((JavaClass)updatedComparatorObject);
                                    comparatorDefinition.setValue("fieldPaths", (Object)PlannerDomainHandler.this.getAnnotationDef(updatedComparatorObject.getObjectPropertyPathList()));
                                } else {
                                    dataObject.removeAnnotation(comparatorDefinition.getClassName());
                                    Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
                                    if (planningEntityAnnotation != null) {
                                        planningEntityAnnotation.removeValue("difficultyComparatorClass");
                                    }
                                }
                            }
                        })).updateComparatorObject(dataObject, comparatorObject, comparatorObject.getObjectPropertyPathList());
                    }
                } else if (event instanceof DataObjectChangeEvent) {
                    if (((DataObjectChangeEvent)event).getChangeType() == ChangeType.OBJECT_NAME_CHANGE || ((DataObjectChangeEvent)event).getChangeType() == ChangeType.PACKAGE_NAME_CHANGE || ((DataObjectChangeEvent)event).getChangeType() == ChangeType.CLASS_NAME_CHANGE) {
                        Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
                        planningEntityAnnotation.setValue("difficultyComparatorClass", (Object)(dataObject.getName() + "." + dataObject.getName() + "Comparator.class"));
                        ((PlannerDataObjectEditorService)this.plannerDataObjectEditorService.call((RemoteCallback)new RemoteCallback<ComparatorObject>(){

                            public void callback(ComparatorObject updatedComparatorObject) {
                                dataObject.getNestedClasses().clear();
                                if (updatedComparatorObject != null) {
                                    dataObject.addNestedClass((JavaClass)updatedComparatorObject);
                                    comparatorDefinition.setValue("fieldPaths", (Object)PlannerDomainHandler.this.getAnnotationDef(updatedComparatorObject.getObjectPropertyPathList()));
                                } else {
                                    dataObject.removeAnnotation(comparatorDefinition.getClassName());
                                    Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
                                    if (planningEntityAnnotation != null) {
                                        planningEntityAnnotation.removeValue("difficultyComparatorClass");
                                    }
                                }
                            }
                        })).updateComparatorObject(dataObject, comparatorObject, comparatorObject.getObjectPropertyPathList());
                    }
                } else if (event instanceof DataObjectFieldChangeEvent) {
                    if (((DataObjectFieldChangeEvent)event).getChangeType() == ChangeType.FIELD_NAME_CHANGE) {
                        for (ObjectPropertyPath objectPropertyPath : comparatorObject.getObjectPropertyPathList()) {
                            List objectPropertyList = objectPropertyPath.getObjectPropertyPath();
                            if (objectPropertyList == null || objectPropertyList.isEmpty() || !((ObjectProperty)objectPropertyList.get(0)).getName().equals(((DataObjectFieldChangeEvent)event).getOldValue())) continue;
                            ((ObjectProperty)objectPropertyList.get(0)).setName(((DataObjectFieldChangeEvent)event).getNewValue().toString());
                            break;
                        }
                        ((PlannerDataObjectEditorService)this.plannerDataObjectEditorService.call((RemoteCallback)new RemoteCallback<ComparatorObject>(){

                            public void callback(ComparatorObject updatedComparatorObject) {
                                dataObject.getNestedClasses().clear();
                                if (updatedComparatorObject != null) {
                                    dataObject.addNestedClass((JavaClass)updatedComparatorObject);
                                    comparatorDefinition.setValue("fieldPaths", (Object)PlannerDomainHandler.this.getAnnotationDef(updatedComparatorObject.getObjectPropertyPathList()));
                                } else {
                                    dataObject.removeAnnotation(comparatorDefinition.getClassName());
                                    Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
                                    if (planningEntityAnnotation != null) {
                                        planningEntityAnnotation.removeValue("difficultyComparatorClass");
                                    }
                                }
                            }
                        })).updateComparatorObject(dataObject, comparatorObject, comparatorObject.getObjectPropertyPathList());
                    } else if (((DataObjectFieldChangeEvent)event).getChangeType() == ChangeType.FIELD_TYPE_CHANGE) {
                        boolean changed = false;
                        ListIterator objectPropertyPathListIterator = comparatorObject.getObjectPropertyPathList().listIterator();
                        while (objectPropertyPathListIterator.hasNext()) {
                            ObjectPropertyPath objectPropertyPath = (ObjectPropertyPath)objectPropertyPathListIterator.next();
                            ListIterator iterator = objectPropertyPath.getObjectPropertyPath().listIterator();
                            boolean remove = false;
                            while (iterator.hasNext()) {
                                ObjectProperty objectProperty = (ObjectProperty)iterator.next();
                                if (remove) {
                                    iterator.remove();
                                    continue;
                                }
                                if (!objectProperty.equals(event.getCurrentField())) continue;
                                remove = true;
                                changed = true;
                            }
                            if (!objectPropertyPath.getObjectPropertyPath().isEmpty()) continue;
                            objectPropertyPathListIterator.remove();
                        }
                        if (changed) {
                            ((PlannerDataObjectEditorService)this.plannerDataObjectEditorService.call((RemoteCallback)new RemoteCallback<ComparatorObject>(){

                                public void callback(ComparatorObject updatedComparatorObject) {
                                    dataObject.getNestedClasses().clear();
                                    if (updatedComparatorObject != null) {
                                        dataObject.addNestedClass((JavaClass)updatedComparatorObject);
                                        comparatorDefinition.setValue("fieldPaths", (Object)PlannerDomainHandler.this.getAnnotationDef(updatedComparatorObject.getObjectPropertyPathList()));
                                    } else {
                                        dataObject.removeAnnotation(comparatorDefinition.getClassName());
                                        Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
                                        if (planningEntityAnnotation != null) {
                                            planningEntityAnnotation.removeValue("difficultyComparatorClass");
                                        }
                                    }
                                }
                            })).updateComparatorObject(dataObject, comparatorObject, comparatorObject.getObjectPropertyPathList());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error while processing data modeller event " + event, (Throwable)e);
        }
    }

    private ComparatorObject getComparatorNestedClass(DataObject dataObject) {
        for (JavaClass javaClass : dataObject.getNestedClasses()) {
            if (!(javaClass instanceof ComparatorObject)) continue;
            return (ComparatorObject)javaClass;
        }
        throw new IllegalStateException("Data object " + dataObject.getClassName() + " contains " + ComparatorDefinition.class.getName() + " annotation, however no nested comparator object is present.");
    }

    private List<String> getAnnotationDef(List<ObjectPropertyPath> objectPropertyPaths) {
        ArrayList<String> objectPropertyPathList = new ArrayList<String>();
        for (ObjectPropertyPath objectPropertyPath : objectPropertyPaths) {
            StringBuilder pathBuilder = new StringBuilder();
            List path = objectPropertyPath.getObjectPropertyPath();
            for (int i = 0; i < path.size(); ++i) {
                ObjectProperty objectProperty = (ObjectProperty)path.get(i);
                pathBuilder.append(objectProperty.getClassName()).append(":").append(objectProperty.getName());
                if (i == path.size() - 1) continue;
                pathBuilder.append("-");
            }
            pathBuilder.append("=").append(objectPropertyPath.isDescending() ? "desc" : "asc");
            objectPropertyPathList.add(pathBuilder.toString());
        }
        return objectPropertyPathList;
    }
}

