/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItem;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorObject;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;

public class DataObjectFieldPicker
implements DataObjectFieldPickerView.Presenter,
IsWidget {
    private List<DataObjectFieldPickerItem> fieldPickerItemList = new ArrayList<DataObjectFieldPickerItem>();
    ManagedInstance<DataObjectFieldPickerItem> fieldPickerItemProducer;
    private DataModel dataModel;
    private DataObject rootDataObject;
    private DataObjectFieldPickerView view;
    private PlannerDataObjectEditorView.Presenter presenter;

    @Inject
    public DataObjectFieldPicker(DataObjectFieldPickerView view, ManagedInstance<DataObjectFieldPickerItem> fieldPickerItemProducer) {
        this.view = view;
        this.fieldPickerItemProducer = fieldPickerItemProducer;
        view.setPresenter(this);
    }

    public void init(DataModel dataModel, DataObject rootDataObject, ComparatorObject comparatorObject, PlannerDataObjectEditorView.Presenter presenter) {
        this.dataModel = dataModel;
        this.rootDataObject = rootDataObject;
        this.presenter = presenter;
        this.view.displayComparatorCheckbox(true);
        this.view.clear();
        for (DataObjectFieldPickerItem item : this.fieldPickerItemList) {
            this.fieldPickerItemProducer.destroy((Object)item);
        }
        this.fieldPickerItemList.clear();
        if (comparatorObject != null && comparatorObject.getObjectPropertyPathList() != null) {
            this.view.setComparatorCheckboxValue(true);
            this.view.displayFieldPicker(true);
            for (ObjectPropertyPath path : comparatorObject.getObjectPropertyPathList()) {
                DataObjectFieldPickerItem fieldPickerItem = this.addFieldPickerItem();
                for (ObjectProperty field : path.getObjectPropertyPath()) {
                    fieldPickerItem.onFieldAdded(field.getName(), false);
                    fieldPickerItem.onOrderSelectValueChange(path.isDescending(), false);
                }
            }
        }
    }

    public void destroy() {
        this.view.displayComparatorCheckbox(false);
        this.view.displayFieldPicker(false);
        this.view.clear();
        for (DataObjectFieldPickerItem item : this.fieldPickerItemList) {
            this.fieldPickerItemProducer.destroy((Object)item);
        }
        this.fieldPickerItemList.clear();
    }

    @Override
    public void onFieldPickerItemRemoved(DataObjectFieldPickerItem fieldPickerItem) {
        int removeIndex = this.fieldPickerItemList.indexOf(fieldPickerItem);
        this.view.removeFieldPickerItem(removeIndex);
        this.fieldPickerItemList.remove(fieldPickerItem);
        for (int i = removeIndex; i < this.fieldPickerItemList.size(); ++i) {
            this.fieldPickerItemList.get(i).setFieldPickerItemIndex(i + 1);
        }
        this.fieldPickerItemProducer.destroy((Object)fieldPickerItem);
        this.objectPropertyPathChanged();
    }

    @Override
    public void onComparatorSpecified(boolean specified) {
        this.view.displayFieldPicker(specified);
        if (!specified) {
            this.presenter.removeComparatorDefinition(this.rootDataObject, true);
            this.view.clear();
            for (DataObjectFieldPickerItem item : this.fieldPickerItemList) {
                this.fieldPickerItemProducer.destroy((Object)item);
            }
            this.fieldPickerItemList.clear();
        }
    }

    @Override
    public void onMoveFieldPickerItemUp(DataObjectFieldPickerItem fieldPickerItem) {
        int currentIndex = this.fieldPickerItemList.indexOf(fieldPickerItem);
        this.view.moveFieldItemUp(currentIndex);
        if (currentIndex > 0) {
            DataObjectFieldPickerItem swapWithItem = this.fieldPickerItemList.get(currentIndex - 1);
            swapWithItem.setFieldPickerItemIndex(currentIndex + 1);
            fieldPickerItem.setFieldPickerItemIndex(currentIndex);
            Collections.swap(this.fieldPickerItemList, currentIndex, currentIndex - 1);
        }
        this.objectPropertyPathChanged();
    }

    @Override
    public void onMoveFieldPickerItemDown(DataObjectFieldPickerItem fieldPickerItem) {
        int currentIndex = this.fieldPickerItemList.indexOf(fieldPickerItem);
        this.view.moveFieldItemDown(currentIndex);
        if (currentIndex < this.fieldPickerItemList.size() - 1) {
            DataObjectFieldPickerItem swapWithItem = this.fieldPickerItemList.get(currentIndex + 1);
            swapWithItem.setFieldPickerItemIndex(currentIndex + 1);
            fieldPickerItem.setFieldPickerItemIndex(currentIndex + 2);
            Collections.swap(this.fieldPickerItemList, currentIndex, currentIndex + 1);
        }
        this.objectPropertyPathChanged();
    }

    @Override
    public DataObjectFieldPickerItem addFieldPickerItem() {
        DataObjectFieldPickerItem fieldPickerItem = (DataObjectFieldPickerItem)this.fieldPickerItemProducer.get();
        fieldPickerItem.init(this.dataModel, this.rootDataObject, this);
        this.fieldPickerItemList.add(fieldPickerItem);
        this.view.addFieldPickerItem(fieldPickerItem);
        fieldPickerItem.setFieldPickerItemIndex(this.fieldPickerItemList.size());
        return fieldPickerItem;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void objectPropertyPathChanged() {
        ArrayList<ObjectPropertyPath> objectPropertyPathList = new ArrayList<ObjectPropertyPath>();
        for (DataObjectFieldPickerItem item : this.fieldPickerItemList) {
            if (item.getObjectPropertyPath().getObjectPropertyPath().isEmpty()) continue;
            objectPropertyPathList.add(item.getObjectPropertyPath());
        }
        this.presenter.objectPropertyPathChanged(objectPropertyPathList);
    }
}

