/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPicker;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemView;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl;

public class DataObjectFieldPickerItem
implements DataObjectFieldPickerItemView.Presenter,
IsWidget {
    private DataObjectFieldPickerItemView view;
    private DataModel dataModel;
    private ObjectPropertyPath objectPropertyPath = new ObjectPropertyPathImpl();
    private DataObject rootDataObject;
    private DataObjectFieldPicker picker;

    @Inject
    public DataObjectFieldPickerItem(DataObjectFieldPickerItemView view) {
        this.view = view;
        view.setPresenter(this);
    }

    public void init(DataModel dataModel, DataObject rootDataObject, DataObjectFieldPicker picker) {
        this.dataModel = dataModel;
        this.rootDataObject = rootDataObject;
        this.picker = picker;
        this.initSelectFieldDropdownOptions(rootDataObject);
        this.view.addFieldItem(rootDataObject.getName(), null, true);
        this.view.setOrderSelectDescendingValue(false);
    }

    private void initSelectFieldDropdownOptions(DataObject dataObject) {
        ArrayList<String> selectFieldOptions = new ArrayList<String>();
        for (ObjectProperty objectProperty : dataObject.getProperties()) {
            if (!DataModelerUtils.isManagedProperty((ObjectProperty)objectProperty)) continue;
            selectFieldOptions.add(objectProperty.getName());
        }
        this.view.initSelectFieldDropdownOptions(selectFieldOptions);
    }

    @Override
    public void onFieldAdded(String field, boolean notify) {
        ObjectProperty objectProperty;
        if (this.objectPropertyPath.getObjectPropertyPath().isEmpty()) {
            objectProperty = this.rootDataObject.getProperty(field);
        } else {
            ObjectProperty parentObjectProperty = (ObjectProperty)this.objectPropertyPath.getObjectPropertyPath().get(this.objectPropertyPath.getObjectPropertyPath().size() - 1);
            DataObject dataObject = this.dataModel.getDataObject(parentObjectProperty.getClassName());
            if (dataObject == null) {
                throw new IllegalStateException("Data object " + parentObjectProperty.getClassName() + " not found in the data model");
            }
            objectProperty = dataObject.getProperty(field);
            if (objectProperty == null) {
                throw new IllegalStateException("Object property " + field + " not found in data object " + dataObject.getClassName());
            }
        }
        this.objectPropertyPath.appendObjectProperty(objectProperty);
        this.view.addFieldItem(field, objectProperty, false);
        if (objectProperty.isBaseType() || objectProperty.isPrimitiveType()) {
            this.view.displaySelectFieldButton(false);
        } else {
            DataObject dataObject = this.dataModel.getDataObject(objectProperty.getClassName());
            this.initSelectFieldDropdownOptions(dataObject);
            this.view.displaySelectFieldButton(true);
        }
        if (notify) {
            this.picker.objectPropertyPathChanged();
        }
    }

    @Override
    public void onFieldRemoved(ObjectProperty objectProperty) {
        DataObject dataObject;
        for (int i = this.objectPropertyPath.getObjectPropertyPath().size() - 1; i >= 0; --i) {
            ObjectProperty currentObjectProperty = (ObjectProperty)this.objectPropertyPath.getObjectPropertyPath().get(i);
            this.objectPropertyPath.getObjectPropertyPath().remove(i);
            this.view.removeLastFieldItem();
            if (currentObjectProperty.equals(objectProperty)) break;
        }
        if (this.objectPropertyPath.getObjectPropertyPath().isEmpty()) {
            dataObject = this.rootDataObject;
        } else {
            ObjectProperty parentObjectProperty = (ObjectProperty)this.objectPropertyPath.getObjectPropertyPath().get(this.objectPropertyPath.getObjectPropertyPath().size() - 1);
            dataObject = this.dataModel.getDataObject(parentObjectProperty.getClassName());
        }
        this.initSelectFieldDropdownOptions(dataObject);
        this.view.displaySelectFieldButton(true);
        this.picker.objectPropertyPathChanged();
    }

    @Override
    public void onRootLabelRemoved() {
        this.picker.onFieldPickerItemRemoved(this);
    }

    @Override
    public void onMoveFieldItemUp() {
        this.picker.onMoveFieldPickerItemUp(this);
    }

    @Override
    public void onMoveFieldItemDown() {
        this.picker.onMoveFieldPickerItemDown(this);
    }

    @Override
    public void onOrderSelectValueChange(boolean descending, boolean notify) {
        this.view.setOrderSelectDescendingValue(descending);
        this.objectPropertyPath.setDescending(descending);
        if (notify) {
            this.picker.objectPropertyPathChanged();
        }
    }

    @Override
    public void setFieldPickerItemIndex(int index) {
        this.view.setFieldPickerItemIndex(index);
    }

    public ObjectPropertyPath getObjectPropertyPath() {
        return this.objectPropertyPath;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }
}

