/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemView;

@Templated
public class DataObjectFieldPickerItemViewImpl
extends Composite
implements DataObjectFieldPickerItemView {
    @Inject
    @DataField(value="view")
    Div view;
    @DataField(value="fieldPickerItemRow")
    HorizontalPanel fieldPickerItemRow;
    @Inject
    @DataField(value="selectFieldButton")
    org.jboss.errai.common.client.dom.Button selectFieldButton;
    @Inject
    @DataField(value="selectFieldDropdown")
    DropDownMenu selectFieldDropdown;
    @DataField(value="moveUpButton")
    Button moveUpButton;
    @DataField(value="moveDownButton")
    Button moveDownButton;
    @Inject
    @DataField(value="orderSelect")
    Select orderSelect;
    private com.google.gwt.user.client.ui.Label sortIndexLabel;
    private DataObjectFieldPickerItemView.Presenter presenter;

    @Inject
    public DataObjectFieldPickerItemViewImpl(HorizontalPanel fieldPickerItemRow, com.google.gwt.user.client.ui.Label sortIndexLabel, Button moveUpButton, Button moveDownButton) {
        this.fieldPickerItemRow = fieldPickerItemRow;
        this.sortIndexLabel = sortIndexLabel;
        this.moveUpButton = moveUpButton;
        this.moveDownButton = moveDownButton;
        sortIndexLabel.getElement().getStyle().setPaddingRight(5.0, Style.Unit.PX);
        sortIndexLabel.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        fieldPickerItemRow.add((Widget)sortIndexLabel);
        moveUpButton.setIcon(IconType.ARROW_UP);
        moveDownButton.setIcon(IconType.ARROW_DOWN);
    }

    @Override
    public void setPresenter(DataObjectFieldPickerItemView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initSelectFieldDropdownOptions(List<String> options) {
        this.selectFieldDropdown.clear();
        for (String option : options) {
            AnchorListItem listItem = new AnchorListItem(option);
            listItem.addClickHandler(c -> this.presenter.onFieldAdded(option, true));
            this.selectFieldDropdown.add((Widget)listItem);
        }
    }

    @Override
    public void addFieldItem(String field, ObjectProperty objectProperty, boolean rootItem) {
        if (rootItem) {
            Label label = new Label(field);
            label.addClickHandler(c -> this.presenter.onRootLabelRemoved());
            label.setMarginRight(5.0);
            this.fieldPickerItemRow.add((Widget)label);
        } else {
            Label label = new Label(field);
            label.addClickHandler(c -> this.presenter.onFieldRemoved(objectProperty));
            label.setMarginRight(5.0);
            this.fieldPickerItemRow.add((Widget)label);
        }
    }

    @Override
    public void removeLastFieldItem() {
        Label label = (Label)this.fieldPickerItemRow.getWidget(this.fieldPickerItemRow.getWidgetCount() - 1);
        this.fieldPickerItemRow.remove((Widget)label);
    }

    @Override
    public void displaySelectFieldButton(boolean display) {
        this.selectFieldButton.getStyle().setProperty("display", display ? "inline" : "none");
    }

    @Override
    public void setOrderSelectDescendingValue(boolean descending) {
        this.orderSelect.setValue(descending ? "desc" : "asc");
    }

    @Override
    public void setFieldPickerItemIndex(int index) {
        this.sortIndexLabel.setText(index + ".");
    }

    @EventHandler(value={"moveUpButton"})
    public void onMoveUpButtonClicked(ClickEvent event) {
        this.presenter.onMoveFieldItemUp();
    }

    @EventHandler(value={"moveDownButton"})
    public void onMoveDownButtonClicked(ClickEvent event) {
        this.presenter.onMoveFieldItemDown();
    }

    @EventHandler(value={"orderSelect"})
    public void onOrderSelectValueChange(ChangeEvent event) {
        this.presenter.onOrderSelectValueChange("desc".equals(this.orderSelect.getValue()), true);
    }
}

