/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.workbench.screens.domaineditor.client.resources.i18n.DomainEditorConstants;
import org.optaplanner.workbench.screens.domaineditor.client.resources.i18n.DomainEditorLookupConstants;
import org.optaplanner.workbench.screens.domaineditor.client.util.PlannerDomainTypes;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorObject;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.optaplanner.workbench.screens.domaineditor.service.PlannerDataObjectEditorService;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
public class PlannerDataObjectEditor
extends ObjectEditor
implements PlannerDataObjectEditorView.Presenter {
    private Caller<PlannerDataObjectEditorService> plannerDataObjectEditorService;
    private PlannerDataObjectEditorView view;
    private ComparatorObject comparatorObject;

    @Inject
    public PlannerDataObjectEditor(PlannerDataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, Caller<PlannerDataObjectEditorService> plannerDataObjectEditorService) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        this.plannerDataObjectEditorService = plannerDataObjectEditorService;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String getName() {
        return "PLANNER_OBJECT_EDITOR";
    }

    public String getDomainName() {
        return "PLANNER_DOMAIN";
    }

    public void onContextChange(DataModelerContext context) {
        super.onContextChange(context);
        this.adjustSelectedPlanningSolutionScoreType();
    }

    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.dataObject = dataObject;
        this.comparatorObject = null;
        if (dataObject != null) {
            boolean hasPlanningEntity = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null;
            boolean hasPlanningSolution = dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null;
            this.view.setPlanningEntityValue(hasPlanningEntity);
            this.view.setPlanningSolutionValue(hasPlanningSolution);
            this.view.showPlanningSolutionScoreType(hasPlanningSolution);
            this.view.setNotInPlanningValue(!hasPlanningEntity && !hasPlanningSolution);
            this.view.destroyFieldPicker();
            if (hasPlanningEntity) {
                if (dataObject.getAnnotation(ComparatorDefinition.class.getName()) != null && !dataObject.getNestedClasses().isEmpty()) {
                    for (JavaClass javaClass : dataObject.getNestedClasses()) {
                        if (!(javaClass instanceof ComparatorObject)) continue;
                        this.comparatorObject = (ComparatorObject)javaClass;
                        break;
                    }
                }
                this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), this.comparatorObject);
            }
        }
    }

    public void clear() {
        this.view.clear();
        this.view.setNotInPlanningValue(true);
    }

    @Override
    public void objectPropertyPathChanged(List<ObjectPropertyPath> objectPropertyPaths) {
        if (objectPropertyPaths == null || objectPropertyPaths.isEmpty()) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.context, this.getName(), this.dataObject, ComparatorDefinition.class.getName()).execute();
            this.commandBuilder.buildDataObjectRemoveNestedClassCommand(this.context, this.getName(), this.dataObject, (JavaClass)this.comparatorObject).execute();
            this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.comparatorObject = null;
            this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), null);
            return;
        }
        ArrayList<String> objectPropertyPathList = new ArrayList<String>();
        for (ObjectPropertyPath objectPropertyPath : objectPropertyPaths) {
            StringBuilder pathBuilder = new StringBuilder();
            List path = objectPropertyPath.getObjectPropertyPath();
            for (int i = 0; i < path.size(); ++i) {
                ObjectProperty objectProperty = (ObjectProperty)path.get(i);
                pathBuilder.append(objectProperty.getClassName()).append(":").append(objectProperty.getName());
                if (i == path.size() - 1) continue;
                pathBuilder.append("-");
            }
            pathBuilder.append("=").append(objectPropertyPath.isDescending() ? "desc" : "asc");
            objectPropertyPathList.add(pathBuilder.toString());
        }
        this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), ComparatorDefinition.class.getName(), Arrays.asList(new ValuePair("fieldPaths", objectPropertyPathList))).execute();
        ((PlannerDataObjectEditorService)this.plannerDataObjectEditorService.call((RemoteCallback)new RemoteCallback<ComparatorObject>(){

            public void callback(ComparatorObject comparatorObject) {
                PlannerDataObjectEditor.this.comparatorObject = comparatorObject;
                PlannerDataObjectEditor.this.dataObject.getNestedClasses().clear();
                PlannerDataObjectEditor.this.commandBuilder.buildDataObjectAddNestedClassCommand(PlannerDataObjectEditor.this.getContext(), PlannerDataObjectEditor.this.getName(), PlannerDataObjectEditor.this.getDataObject(), (JavaClass)comparatorObject).execute();
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                PlannerDataObjectEditor.this.view.initFieldPicker(PlannerDataObjectEditor.this.getContext().getDataModel(), PlannerDataObjectEditor.this.getDataObject(), PlannerDataObjectEditor.this.comparatorObject);
                ErrorPopup.showMessage((String)(DomainEditorConstants.INSTANCE.UnexpectedErrorComparatorUpdate() + " " + throwable.getMessage()));
                return false;
            }
        })).updateComparatorObject(this.getDataObject(), this.comparatorObject, objectPropertyPaths);
        List<ValuePair> valuePairList = Arrays.asList(new ValuePair("difficultyComparatorClass", (Object)(this.getDataObject().getName() + "." + this.getDataObject().getName() + "Comparator.class")));
        this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity", valuePairList).execute();
    }

    @Override
    public void removeComparatorDefinition(DataObject dataObject, boolean resetPlanningEntityAnnotation) {
        if (this.comparatorObject != null) {
            this.commandBuilder.buildDataObjectRemoveNestedClassCommand(this.getContext(), this.getName(), dataObject, (JavaClass)this.comparatorObject).execute();
            this.comparatorObject = null;
        }
        this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), ComparatorDefinition.class.getName()).execute();
        if (resetPlanningEntityAnnotation) {
            this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
        }
    }

    @Override
    public void onNotInPlanningChange() {
        boolean value = this.view.getNotInPlanningValue();
        if (value && this.dataObject != null) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
            if (this.isPlannerSolution(this.getDataObject().getSuperClassName())) {
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
            }
            this.removeComparatorDefinition(this.getDataObject(), false);
            this.view.destroyFieldPicker();
            this.view.showPlanningSolutionScoreType(false);
        }
    }

    @Override
    public void onPlanningEntityChange() {
        boolean value = this.view.getPlanningEntityValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                if (this.isPlannerSolution(this.getDataObject().getSuperClassName())) {
                    this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                }
                this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), null);
                this.view.showPlanningSolutionScoreType(false);
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            }
        }
    }

    @Override
    public void onPlanningSolutionChange() {
        boolean value = this.view.getPlanningSolutionValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.buildPlanningSolutionScoreTypeSuperClass(this.getDefaultSolutionScoreType())).execute();
                this.removeComparatorDefinition(this.getDataObject(), false);
                this.view.destroyFieldPicker();
                this.view.showPlanningSolutionScoreType(true);
                this.view.setPlanningSolutionScoreType(this.getDefaultSolutionScoreType());
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                this.view.showPlanningSolutionScoreType(false);
            }
        }
    }

    @Override
    public void onPlanningSolutionScoreTypeChange() {
        String planningSolutionScoreType = this.view.getPlanningSolutionScoreType();
        String superClass = this.buildPlanningSolutionScoreTypeSuperClass(planningSolutionScoreType);
        if (superClass != null) {
            this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), superClass).execute();
        }
    }

    protected void onDataObjectChange(@Observes DataObjectChangeEvent event) {
        super.onDataObjectChange(event);
        if (event.isFromContext(this.getContext() != null ? this.getContext().getContextId() : null) && !event.isFrom(this.getName()) && event.getChangeType() == ChangeType.SUPER_CLASS_NAME_CHANGE && this.getDataObject() != null && this.getDataObject().getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null && !this.isPlannerSolution(this.getDataObject().getSuperClassName()) && this.isPlannerSolution(event.getOldValue() != null ? event.getOldValue().toString() : null)) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
        }
    }

    private boolean isPlannerSolution(String superClassName) {
        return superClassName != null && (superClassName.startsWith("org.optaplanner.core.impl.domain.solution.AbstractSolution") || superClassName.startsWith("AbstractSolution"));
    }

    private List<Pair<String, String>> getPlanningSolutionScoreTypeOptions() {
        ArrayList<Pair<String, String>> planningSolutionScoreTypeOptions = new ArrayList<Pair<String, String>>(PlannerDomainTypes.SCORE_TYPES.size());
        for (Class<? extends Score> scoreClass : PlannerDomainTypes.SCORE_TYPES) {
            planningSolutionScoreTypeOptions.add((Pair<String, String>)new Pair((Object)DomainEditorLookupConstants.INSTANCE.getString(scoreClass.getSimpleName()), (Object)scoreClass.getName()));
        }
        return planningSolutionScoreTypeOptions;
    }

    private String buildPlanningSolutionScoreTypeSuperClass(String planningSolutionScoreType) {
        return planningSolutionScoreType != null ? "org.optaplanner.core.impl.domain.solution.AbstractSolution<" + planningSolutionScoreType + ">" : null;
    }

    private void adjustSelectedPlanningSolutionScoreType() {
        if (this.context != null && this.context.getEditorModelContent() != null && this.context.getEditorModelContent().getSource() != null) {
            String selectedScoreType = this.getSelectedPlanningSolutionTypeFromSource(this.context.getEditorModelContent().getSource());
            if (selectedScoreType == null) {
                selectedScoreType = this.getDefaultSolutionScoreType();
            }
            this.view.initPlanningSolutionScoreTypeOptions(this.getPlanningSolutionScoreTypeOptions(), selectedScoreType);
        }
    }

    private String getSelectedPlanningSolutionTypeFromSource(String source) {
        for (Class<? extends Score> scoreClass : PlannerDomainTypes.SCORE_TYPES) {
            if (!source.contains("AbstractSolution<" + scoreClass.getSimpleName() + ">") && !source.contains("AbstractSolution<" + scoreClass.getName() + ">")) continue;
            return scoreClass.getName();
        }
        return null;
    }

    private String getDefaultSolutionScoreType() {
        return HardSoftScore.class.getName();
    }
}

