/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datamodeller.client.util.UIUtil;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.optaplanner.workbench.screens.domaineditor.client.resources.i18n.DomainEditorConstants;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPicker;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorObject;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

@Dependent
@Templated
public class PlannerDataObjectEditorViewImpl
extends Composite
implements PlannerDataObjectEditorView {
    @Inject
    @DataField(value="notInPlanningRadioButton")
    Input notInPlanningRadioButton;
    @Inject
    @DataField(value="planningEntityRadioButton")
    Input planningEntityRadioButton;
    @Inject
    @DataField(value="planningSolutionRadioButton")
    Input planningSolutionRadioButton;
    @Inject
    @DataField(value="planningSolutionScoreTypeGroup")
    Div planningSolutionScoreTypeGroup;
    @Inject
    @DataField(value="planningSolutionScoreTypeSelector")
    Select planningSolutionScoreTypeSelector;
    @Inject
    @DataField(value="fieldPicker")
    DataObjectFieldPicker fieldPicker;
    @Inject
    @DataField(value="comparatorGroup")
    Div comparatorGroup;
    private PlannerDataObjectEditorView.Presenter presenter;

    public void init(PlannerDataObjectEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setNotInPlanningValue(boolean value) {
        this.notInPlanningRadioButton.setChecked(value);
    }

    @Override
    public boolean getNotInPlanningValue() {
        return this.notInPlanningRadioButton.getChecked();
    }

    @Override
    public void setPlanningEntityValue(boolean value) {
        this.planningEntityRadioButton.setChecked(value);
    }

    @Override
    public boolean getPlanningEntityValue() {
        return this.planningEntityRadioButton.getChecked();
    }

    @Override
    public void setPlanningSolutionValue(boolean value) {
        this.planningSolutionRadioButton.setChecked(value);
    }

    @Override
    public boolean getPlanningSolutionValue() {
        return this.planningSolutionRadioButton.getChecked();
    }

    @Override
    public void clear() {
        this.setNotInPlanningValue(false);
        this.setPlanningEntityValue(false);
        this.setPlanningSolutionValue(false);
    }

    @Override
    public void initFieldPicker(DataModel dataModel, DataObject rootDataObject, ComparatorObject comparatorObject) {
        try {
            this.fieldPicker.init(dataModel, rootDataObject, comparatorObject, this.presenter);
        }
        catch (Exception e) {
            ErrorPopup.showMessage((String)(DomainEditorConstants.INSTANCE.UnexpectedErrorComparatorInit() + " " + e.getMessage()));
            this.fieldPicker.destroy();
        }
    }

    @Override
    public void destroyFieldPicker() {
        this.fieldPicker.destroy();
    }

    @Override
    public void initPlanningSolutionScoreTypeOptions(List<Pair<String, String>> options, String selectedScoreType) {
        UIUtil.initList((Select)this.planningSolutionScoreTypeSelector, options, (String)selectedScoreType, (boolean)false);
    }

    @Override
    public String getPlanningSolutionScoreType() {
        return this.planningSolutionScoreTypeSelector.getValue();
    }

    @Override
    public void showPlanningSolutionScoreType(boolean show) {
        this.planningSolutionScoreTypeGroup.setHidden(!show);
    }

    @Override
    public void showComparatorGroup(boolean show) {
        this.comparatorGroup.setHidden(!show);
    }

    @Override
    public void setPlanningSolutionScoreType(String scoreType) {
        UIUtil.setSelectedValue((Select)this.planningSolutionScoreTypeSelector, (String)scoreType);
    }

    @EventHandler(value={"notInPlanningRadioButton"})
    void onNotInPlanningChange(ClickEvent event) {
        this.presenter.onNotInPlanningChange();
    }

    @EventHandler(value={"planningEntityRadioButton"})
    void onPlanningEntityChange(ClickEvent event) {
        this.presenter.onPlanningEntityChange();
    }

    @EventHandler(value={"planningSolutionRadioButton"})
    void onPlanningSolutionChange(ClickEvent event) {
        this.presenter.onPlanningSolutionChange();
    }

    @EventHandler(value={"planningSolutionScoreTypeSelector"})
    void setPlanningSolutionScoreTypeChange(ChangeEvent event) {
        this.presenter.onPlanningSolutionScoreTypeChange();
    }
}

