/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.domain.solution.AbstractSolution;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectFieldEditor;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectFieldEditorView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerEditorBaseTest;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlannerDataObjectFieldEditorTest
extends PlannerEditorBaseTest {
    @Mock
    private PlannerDataObjectFieldEditorView view;

    protected PlannerDataObjectFieldEditor createFieldEditor() {
        PlannerDataObjectFieldEditor fieldEditor = new PlannerDataObjectFieldEditor(this.view, this.handlerRegistry, this.dataModelerEvent, this.commandBuilder);
        return fieldEditor;
    }

    @Test
    public void loadDataObjectField() {
        PlannerDataObjectFieldEditor fieldEditor = this.createFieldEditor();
        DataObject dataObject = this.context.getDataObject();
        ObjectProperty field1 = dataObject.getProperty("field1");
        this.context.setObjectProperty(field1);
        fieldEditor.onContextChange(this.context);
        ((PlannerDataObjectFieldEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlannerDataObjectFieldEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningFieldPropertiesNotAvailable(true);
    }

    @Test
    public void fieldPlanningEntitySettings() {
        PlannerDataObjectFieldEditor fieldEditor = this.createFieldEditor();
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation((Annotation)new AnnotationImpl(this.context.getAnnotationDefinition(PlanningEntity.class.getName())));
        ObjectProperty field1 = dataObject.getProperty("field1");
        this.context.setObjectProperty(field1);
        fieldEditor.onContextChange(this.context);
        Mockito.when((Object)this.view.getPlanningVariableValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getValueRangeProviderRefsValue()).thenReturn((Object)"valueRangeProviderRefsValue");
        fieldEditor.onPlanningVariableChange();
        fieldEditor.onValueRangeProviderRefsChange();
        ArrayList<String> valueRangeProviderRefs = new ArrayList<String>();
        valueRangeProviderRefs.add("valueRangeProviderRefsValue");
        Assert.assertNotNull((Object)field1.getAnnotation(PlanningVariable.class.getName()));
        Assert.assertEquals(valueRangeProviderRefs, (Object)field1.getAnnotation(PlanningVariable.class.getName()).getValue("valueRangeProviderRefs"));
    }

    @Test
    public void planningSolutionSettings() {
        PlannerDataObjectFieldEditor fieldEditor = this.createFieldEditor();
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation((Annotation)new AnnotationImpl(this.context.getAnnotationDefinition(PlanningSolution.class.getName())));
        dataObject.setSuperClassName(AbstractSolution.class.getName() + "<" + HardSoftScore.class.getName() + ">");
        ObjectProperty field1 = dataObject.getProperty("field1");
        this.context.setObjectProperty(field1);
        fieldEditor.onContextChange(this.context);
        Mockito.when((Object)this.view.getPlanningEntityCollectionValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getValueRangeProviderValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getValueRangeProviderIdValue()).thenReturn((Object)"valueRangeProviderIdValue");
        fieldEditor.onPlanningEntityCollectionChange();
        fieldEditor.onValueRangeProviderChange();
        fieldEditor.onValueRangeProviderIdChange();
        Assert.assertNotNull((Object)field1.getAnnotation(PlanningEntityCollectionProperty.class.getName()));
        Assert.assertNotNull((Object)field1.getAnnotation(ValueRangeProvider.class.getName()));
        Assert.assertEquals((Object)"valueRangeProviderIdValue", (Object)AnnotationValueHandler.getStringValue((HasAnnotations)field1, (String)ValueRangeProvider.class.getName(), (String)"id"));
    }
}

