/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.util.ErrorPopupHelper;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ParameterImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.TypeImpl;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.workbench.screens.domaineditor.client.handlers.planner.ComparatorDefinitionAnnotationValueHandler;
import org.optaplanner.workbench.screens.domaineditor.client.resources.i18n.DomainEditorLookupConstants;
import org.optaplanner.workbench.screens.domaineditor.client.util.PlannerDomainTypes;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;
import org.uberfire.commons.data.Pair;

@Dependent
public class PlannerDataObjectEditor
extends ObjectEditor
implements PlannerDataObjectEditorView.Presenter {
    private PlannerDataObjectEditorView view;
    private TranslationService translationService;
    private JavaClass comparatorObject;
    private Caller<ComparatorDefinitionService> comparatorDefinitionService;

    @Inject
    public PlannerDataObjectEditor(PlannerDataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, TranslationService translationService, Caller<ComparatorDefinitionService> comparatorDefinitionService) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        this.translationService = translationService;
        this.comparatorDefinitionService = comparatorDefinitionService;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String getName() {
        return "PLANNER_OBJECT_EDITOR";
    }

    public String getDomainName() {
        return "PLANNER_DOMAIN";
    }

    public void onContextChange(DataModelerContext context) {
        super.onContextChange(context);
        this.adjustSelectedPlanningSolutionScoreType();
    }

    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.dataObject = dataObject;
        this.comparatorObject = null;
        if (dataObject != null) {
            Method getScoreMethod;
            boolean hasPlanningEntity = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null;
            boolean hasPlanningSolution = dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null;
            this.view.setPlanningEntityValue(hasPlanningEntity);
            this.view.setPlanningSolutionValue(hasPlanningSolution);
            this.view.showPlanningSolutionScoreType(hasPlanningSolution);
            this.view.setNotInPlanningValue(!hasPlanningEntity && !hasPlanningSolution);
            this.view.destroyFieldPicker();
            this.view.showPlanningSolutionBendableScoreInput(false);
            if (hasPlanningEntity) {
                if (!dataObject.getNestedClasses().isEmpty()) {
                    for (JavaClass javaClass : dataObject.getNestedClasses()) {
                        if (javaClass.getAnnotation(ComparatorDefinition.class.getName()) == null) continue;
                        try {
                            this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), this.getObjectPropertyPathList(javaClass.getAnnotation(ComparatorDefinition.class.getName())));
                            this.comparatorObject = javaClass;
                            break;
                        }
                        catch (IllegalStateException e) {
                            ErrorPopupHelper.showErrorPopup((String)(this.translationService.getTranslation("PlannerDataObjectEditor.ComparatorDefinitionProcessingFailed") + " " + e.getMessage()));
                        }
                    }
                } else {
                    this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), null);
                }
            }
            if (hasPlanningSolution && (getScoreMethod = dataObject.getMethod("getScore", Collections.EMPTY_LIST)) != null) {
                Type getScoreMethodReturnType = getScoreMethod.getReturnType();
                if (getScoreMethodReturnType != null && this.isBendableScore(getScoreMethod.getReturnType().getName())) {
                    this.view.showPlanningSolutionBendableScoreInput(true);
                    Annotation annotation = getScoreMethod.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningScore");
                    if (annotation != null) {
                        Object hardLevelsSize = annotation.getValue("bendableHardLevelsSize");
                        if (hardLevelsSize != null) {
                            this.view.setPlanningSolutionBendableScoreHardLevelsSize((Integer)hardLevelsSize == -1 ? 0 : (Integer)hardLevelsSize);
                        } else {
                            this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                        }
                        Object softLevelsSize = annotation.getValue("bendableSoftLevelsSize");
                        if (softLevelsSize != null) {
                            this.view.setPlanningSolutionBendableScoreSoftLevelsSize((Integer)softLevelsSize == -1 ? 0 : (Integer)softLevelsSize);
                        } else {
                            this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                        }
                    }
                } else {
                    this.view.showPlanningSolutionBendableScoreInput(false);
                    this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                    this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                }
            }
        }
    }

    private List<ObjectPropertyPath> getObjectPropertyPathList(Annotation comparatorDefinition) {
        ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinition);
        ArrayList<ObjectPropertyPath> objectPropertyPathList = new ArrayList<ObjectPropertyPath>();
        List<Annotation> comparatorFieldPaths = comparatorAnnotationHandler.getObjectPropertyPaths();
        for (Annotation comparatorFieldPath : comparatorFieldPaths) {
            ObjectPropertyPathImpl objectPropertyPath = new ObjectPropertyPathImpl();
            objectPropertyPath.setDescending(!comparatorAnnotationHandler.isAscending(comparatorFieldPath));
            List<Annotation> comparatorFields = comparatorAnnotationHandler.getObjectProperties(comparatorFieldPath);
            if (!comparatorFields.isEmpty()) {
                String objectPropertyName = comparatorAnnotationHandler.getName(comparatorFields.get(0));
                ObjectProperty objectProperty = this.dataObject.getProperty(objectPropertyName);
                if (objectProperty == null) {
                    throw new IllegalStateException(this.dataObject.getName() + "Comparator: Property " + objectPropertyName + " not found in data object " + this.dataObject.getClassName());
                }
                objectPropertyPath.appendObjectProperty(objectProperty);
                for (int i = 1; i < comparatorFields.size(); ++i) {
                    objectPropertyName = comparatorAnnotationHandler.getName(comparatorFields.get(i));
                    ObjectProperty lastObjectPropertyInPath = (ObjectProperty)objectPropertyPath.getObjectPropertyPath().get(objectPropertyPath.getObjectPropertyPath().size() - 1);
                    if (lastObjectPropertyInPath.isBaseType() || lastObjectPropertyInPath.isPrimitiveType()) {
                        throw new IllegalStateException(this.dataObject.getName() + "Comparator: Cannot append property " + objectPropertyName + " to primitive/base type " + lastObjectPropertyInPath.getClassName());
                    }
                    DataObject lastDataObjectInPath = this.getContext().getDataModel().getDataObject(lastObjectPropertyInPath.getClassName());
                    if (lastObjectPropertyInPath == null) {
                        throw new IllegalStateException(this.dataObject.getName() + "Comparator: Data object " + lastObjectPropertyInPath.getClassName() + " not found");
                    }
                    ObjectProperty currentObjectProperty = lastDataObjectInPath.getProperty(objectPropertyName);
                    if (currentObjectProperty == null) {
                        throw new IllegalStateException(this.dataObject.getName() + "Comparator: Property " + objectPropertyName + " not found in data object " + lastDataObjectInPath.getClassName());
                    }
                    objectPropertyPath.appendObjectProperty(currentObjectProperty);
                }
            }
            objectPropertyPathList.add((ObjectPropertyPath)objectPropertyPath);
        }
        return objectPropertyPathList;
    }

    private boolean isBendableScore(String planningSolutionScoreType) {
        return BendableScore.class.getName().equals(planningSolutionScoreType) || BendableLongScore.class.getName().equals(planningSolutionScoreType) || BendableBigDecimalScore.class.getName().equals(planningSolutionScoreType);
    }

    public void clear() {
        this.view.clear();
        this.view.setNotInPlanningValue(true);
    }

    @Override
    public void objectPropertyPathChanged(List<ObjectPropertyPath> objectPropertyPaths, boolean itemsRemoved) {
        if (objectPropertyPaths.isEmpty() && this.view.isFieldPickerEmpty() && itemsRemoved) {
            this.commandBuilder.buildDataObjectRemoveNestedClassCommand(this.context, this.getName(), this.dataObject, this.comparatorObject).execute();
            this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.comparatorObject = null;
            this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), Collections.EMPTY_LIST);
            return;
        }
        if (this.comparatorObject != null) {
            this.comparatorObject.removeAnnotation(ComparatorDefinition.class.getName());
            this.comparatorObject.addAnnotation(ComparatorDefinitionAnnotationValueHandler.createAnnotation(objectPropertyPaths, this.context.getAnnotationDefinitions()));
            ((ComparatorDefinitionService)this.comparatorDefinitionService.call((RemoteCallback)new RemoteCallback<JavaClass>(){

                public void callback(JavaClass updatedComparatorObject) {
                    PlannerDataObjectEditor.this.dataObject.removeNestedClass(PlannerDataObjectEditor.this.comparatorObject);
                    PlannerDataObjectEditor.this.dataObject.addNestedClass(updatedComparatorObject);
                    PlannerDataObjectEditor.this.comparatorObject = updatedComparatorObject;
                }
            })).updateComparatorObject(this.dataObject, this.comparatorObject);
        } else {
            ((ComparatorDefinitionService)this.comparatorDefinitionService.call((RemoteCallback)new RemoteCallback<JavaClass>(){

                public void callback(JavaClass newComparatorObject) {
                    PlannerDataObjectEditor.this.dataObject.addNestedClass(newComparatorObject);
                    PlannerDataObjectEditor.this.comparatorObject = newComparatorObject;
                }
            })).createComparatorObject(this.dataObject);
        }
        List<ValuePair> valuePairList = Arrays.asList(new ValuePair("difficultyComparatorClass", (Object)(this.getDataObject().getName() + ".DifficultyComparator.class")));
        this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity", valuePairList).execute();
    }

    @Override
    public void removeComparatorDefinition(DataObject dataObject, boolean resetPlanningEntityAnnotation) {
        if (this.comparatorObject != null) {
            this.commandBuilder.buildDataObjectRemoveNestedClassCommand(this.getContext(), this.getName(), dataObject, this.comparatorObject).execute();
            this.comparatorObject = null;
        }
        this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), ComparatorDefinition.class.getName()).execute();
        if (resetPlanningEntityAnnotation) {
            this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
        }
    }

    @Override
    public void onNotInPlanningChange() {
        boolean value = this.view.getNotInPlanningValue();
        if (value && this.dataObject != null) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
            if (this.isPlannerSolution(this.getDataObject().getSuperClassName())) {
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
            }
            this.removeComparatorDefinition(this.getDataObject(), false);
            this.view.destroyFieldPicker();
            this.view.showPlanningSolutionScoreType(false);
            this.view.showPlanningSolutionBendableScoreInput(false);
            this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
            this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
            this.removePlanningSolutionScoreAccessorMethods(this.view.getPlanningSolutionScoreType());
        }
    }

    @Override
    public void onPlanningEntityChange() {
        boolean value = this.view.getPlanningEntityValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                if (this.isPlannerSolution(this.getDataObject().getSuperClassName())) {
                    this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                }
                this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), null);
                this.view.showPlanningSolutionScoreType(false);
                this.view.showPlanningSolutionBendableScoreInput(false);
                this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                this.removePlanningSolutionScoreAccessorMethods(this.view.getPlanningSolutionScoreType());
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            }
        }
    }

    @Override
    public void onPlanningSolutionChange() {
        boolean value = this.view.getPlanningSolutionValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.buildPlanningSolutionScoreTypeSuperClass(this.getDefaultSolutionScoreType())).execute();
                this.removeComparatorDefinition(this.getDataObject(), false);
                this.view.destroyFieldPicker();
                this.view.showPlanningSolutionScoreType(true);
                this.view.setPlanningSolutionScoreType(this.getDefaultSolutionScoreType());
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                this.view.showPlanningSolutionScoreType(false);
                this.view.showPlanningSolutionBendableScoreInput(false);
                this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                this.removePlanningSolutionScoreAccessorMethods(this.view.getPlanningSolutionScoreType());
            }
        }
    }

    @Override
    public void onPlanningSolutionScoreTypeChange() {
        String newPlanningSolutionScoreType = this.view.getPlanningSolutionScoreType();
        String superClass = this.buildPlanningSolutionScoreTypeSuperClass(newPlanningSolutionScoreType);
        if (superClass != null) {
            String oldPlanningSolutionScoreType = this.getSelectedPlanningSolutionTypeFromSource(this.context.getEditorModelContent().getSource());
            this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), superClass).execute();
            this.updateScoreMethod(newPlanningSolutionScoreType, oldPlanningSolutionScoreType);
        }
    }

    @Override
    public void onPlanningSolutionBendableScoreHardLevelsSizeChange() {
        this.updateScoreMethod(this.view.getPlanningSolutionScoreType(), null);
    }

    @Override
    public void onPlanningSolutionBendableScoreSoftLevelsSizeChange() {
        this.updateScoreMethod(this.view.getPlanningSolutionScoreType(), null);
    }

    private void updateScoreMethod(String newPlanningSolutionScoreType, String oldPlanningSolutionScoreType) {
        if (this.getDataObject() != null) {
            if (this.isBendableScore(newPlanningSolutionScoreType)) {
                Method getScoreMethod = this.dataObject.getMethod("getScore", Collections.EMPTY_LIST);
                if (oldPlanningSolutionScoreType != null) {
                    this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                    this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                    this.removePlanningSolutionScoreAccessorMethods(oldPlanningSolutionScoreType);
                    getScoreMethod = this.addGetScoreMethod(newPlanningSolutionScoreType);
                    this.addSetScoreMethod(newPlanningSolutionScoreType);
                } else if (getScoreMethod == null) {
                    getScoreMethod = this.addGetScoreMethod(newPlanningSolutionScoreType);
                    this.addSetScoreMethod(newPlanningSolutionScoreType);
                }
                this.view.showPlanningSolutionBendableScoreInput(true);
                List<ValuePair> valuePairList = Arrays.asList(new ValuePair("bendableHardLevelsSize", (Object)this.view.getPlanningSolutionBendableScoreHardLevelsSize()), new ValuePair("bendableSoftLevelsSize", (Object)this.view.getPlanningSolutionBendableScoreSoftLevelsSize()));
                this.commandBuilder.buildMethodAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), getScoreMethod, "org.optaplanner.core.api.domain.solution.PlanningScore", valuePairList).execute();
            } else {
                this.view.showPlanningSolutionBendableScoreInput(false);
                this.removePlanningSolutionScoreAccessorMethods(oldPlanningSolutionScoreType);
            }
        }
    }

    private void removePlanningSolutionScoreAccessorMethods(String solutionScoreType) {
        if (this.getDataObject() != null) {
            Method setScoreMethod;
            Method getScoreMethod = this.dataObject.getMethod("getScore", Collections.EMPTY_LIST);
            if (getScoreMethod != null) {
                this.commandBuilder.buildMethodRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), getScoreMethod).execute();
            }
            if ((setScoreMethod = this.dataObject.getMethod("setScore", Arrays.asList(solutionScoreType))) != null) {
                this.commandBuilder.buildMethodRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), setScoreMethod).execute();
            }
        }
    }

    private Method addGetScoreMethod(String newPlanningSolutionScoreType) {
        TypeImpl getScoreMethodReturnType = new TypeImpl(newPlanningSolutionScoreType);
        MethodImpl getScoreMethod = new MethodImpl("getScore", Collections.EMPTY_LIST, "return score;", (Type)getScoreMethodReturnType, Visibility.PUBLIC);
        this.commandBuilder.buildMethodAddCommand(this.getContext(), this.getName(), this.getDataObject(), (Method)getScoreMethod).execute();
        this.commandBuilder.buildMethodAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), (Method)getScoreMethod, "javax.annotation.Generated", Arrays.asList(new ValuePair("value", (Object)PlannerDataObjectEditor.class.getName()))).execute();
        return getScoreMethod;
    }

    private Method addSetScoreMethod(String newPlanningSolutionScoreType) {
        ParameterImpl setScoreParameter = new ParameterImpl((Type)new TypeImpl(newPlanningSolutionScoreType), "score");
        TypeImpl setScoreMethodReturnType = new TypeImpl(Void.TYPE.getName());
        MethodImpl setScoreMethod = new MethodImpl("setScore", Arrays.asList(setScoreParameter), "this.score = score;", (Type)setScoreMethodReturnType, Visibility.PUBLIC);
        this.commandBuilder.buildMethodAddCommand(this.getContext(), this.getName(), this.getDataObject(), (Method)setScoreMethod).execute();
        this.commandBuilder.buildMethodAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), (Method)setScoreMethod, "javax.annotation.Generated", Arrays.asList(new ValuePair("value", (Object)PlannerDataObjectEditor.class.getName()))).execute();
        return setScoreMethod;
    }

    protected void onDataObjectChange(@Observes DataObjectChangeEvent event) {
        super.onDataObjectChange(event);
        if (event.isFromContext(this.getContext() != null ? this.getContext().getContextId() : null) && !event.isFrom(this.getName()) && event.getChangeType() == ChangeType.SUPER_CLASS_NAME_CHANGE && this.getDataObject() != null && this.getDataObject().getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null && !this.isPlannerSolution(this.getDataObject().getSuperClassName()) && this.isPlannerSolution(event.getOldValue() != null ? event.getOldValue().toString() : null)) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
        }
    }

    private boolean isPlannerSolution(String superClassName) {
        return superClassName != null && (superClassName.startsWith("org.optaplanner.core.impl.domain.solution.AbstractSolution") || superClassName.startsWith("AbstractSolution"));
    }

    private List<Pair<String, String>> getPlanningSolutionScoreTypeOptions() {
        ArrayList<Pair<String, String>> planningSolutionScoreTypeOptions = new ArrayList<Pair<String, String>>(PlannerDomainTypes.SCORE_TYPES.size());
        for (Class<? extends Score> scoreClass : PlannerDomainTypes.SCORE_TYPES) {
            planningSolutionScoreTypeOptions.add((Pair<String, String>)new Pair((Object)DomainEditorLookupConstants.INSTANCE.getString(scoreClass.getSimpleName()), (Object)scoreClass.getName()));
        }
        return planningSolutionScoreTypeOptions;
    }

    private String buildPlanningSolutionScoreTypeSuperClass(String planningSolutionScoreType) {
        return planningSolutionScoreType != null ? "org.optaplanner.core.impl.domain.solution.AbstractSolution<" + planningSolutionScoreType + ">" : null;
    }

    private void adjustSelectedPlanningSolutionScoreType() {
        if (this.context != null && this.context.getEditorModelContent() != null && this.context.getEditorModelContent().getSource() != null) {
            String selectedScoreType = this.getSelectedPlanningSolutionTypeFromSource(this.context.getEditorModelContent().getSource());
            if (selectedScoreType == null) {
                selectedScoreType = this.getDefaultSolutionScoreType();
            }
            this.view.initPlanningSolutionScoreTypeOptions(this.getPlanningSolutionScoreTypeOptions(), selectedScoreType);
        }
    }

    private String getSelectedPlanningSolutionTypeFromSource(String source) {
        for (Class<? extends Score> scoreClass : PlannerDomainTypes.SCORE_TYPES) {
            if (!source.contains("AbstractSolution<" + scoreClass.getSimpleName() + ">") && !source.contains("AbstractSolution<" + scoreClass.getName() + ">")) continue;
            return scoreClass.getName();
        }
        return null;
    }

    private String getDefaultSolutionScoreType() {
        return HardSoftScore.class.getName();
    }
}

