/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Generated;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.client.widgets.DataModelerEditorsTestHelper;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ParameterImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.TypeImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.domain.solution.AbstractSolution;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditor;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerEditorBaseTest;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;
import org.uberfire.commons.data.Pair;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlannerDataObjectEditorTest
extends PlannerEditorBaseTest {
    @Mock
    private PlannerDataObjectEditorView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private Caller<ComparatorDefinitionService> comparatorDefinitionService;

    protected PlannerDataObjectEditor createObjectEditor() {
        PlannerDataObjectEditor objectEditor = new PlannerDataObjectEditor(this.view, this.handlerRegistry, this.dataModelerEvent, this.commandBuilder, this.translationService, this.comparatorDefinitionService);
        return objectEditor;
    }

    @Test
    public void loadDataObject() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningEntityValue(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionValue(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setNotInPlanningValue(true);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).destroyFieldPicker();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(false);
    }

    @Test
    public void loadDataObjectWithBendableScoreType() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningSolution.class, null, null));
        TypeImpl getScoreMethodReturnType = new TypeImpl(BendableScore.class.getName());
        MethodImpl getScoreMethod = new MethodImpl("getScore", Collections.EMPTY_LIST, "return score;", (Type)getScoreMethodReturnType, Visibility.PUBLIC);
        getScoreMethod.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningScore.class, (Pair[])new Pair[]{new Pair((Object)"bendableHardLevelsSize", (Object)5), new Pair((Object)"bendableSoftLevelsSize", (Object)10)}));
        getScoreMethod.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(Generated.class, null, null));
        dataObject.addMethod((Method)getScoreMethod);
        ParameterImpl setScoreParameter = new ParameterImpl((Type)new TypeImpl(BendableScore.class.getName()), "score");
        TypeImpl setScoreParameterReturnType = new TypeImpl(Void.TYPE.getName());
        MethodImpl setScoreMethod = new MethodImpl("setScore", Arrays.asList(setScoreParameter), "this.score = score;", (Type)setScoreParameterReturnType, Visibility.PUBLIC);
        setScoreMethod.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(Generated.class, null, null));
        dataObject.addMethod((Method)setScoreMethod);
        objectEditor.onContextChange(this.context);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreHardLevelsSize(5);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreSoftLevelsSize(10);
    }

    @Test
    public void changeToPlanningEntity() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningEntityValue()).thenReturn((Object)true);
        objectEditor.onPlanningEntityChange();
        DataObject dataObject = this.context.getDataObject();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getPlanningEntityValue();
        Assert.assertNotNull((Object)dataObject.getAnnotation(PlanningEntity.class.getName()));
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initFieldPicker(this.context.getDataModel(), dataObject, null);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreHardLevelsSize(0);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreSoftLevelsSize(0);
    }

    @Test
    public void changeToPlanningSolution() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionValue()).thenReturn((Object)true);
        objectEditor.onPlanningSolutionChange();
        DataObject dataObject = this.context.getDataObject();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getPlanningSolutionValue();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(true);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).destroyFieldPicker();
        Assert.assertNotNull((Object)dataObject.getAnnotation(PlanningSolution.class.getName()));
        Assert.assertEquals((Object)("org.optaplanner.core.impl.domain.solution.AbstractSolution<" + HardSoftScore.class.getName() + ">"), (Object)dataObject.getSuperClassName());
    }

    @Test
    public void onPlanningSolutionScoreTypeChange() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)BendableScore.class.getName());
        this.context.getAnnotationDefinitions().put("org.optaplanner.core.api.domain.solution.PlanningScore", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put(Generated.class.getName(), Mockito.mock(AnnotationDefinition.class));
        this.context.getEditorModelContent().setSource(AbstractSolution.class.getName() + "<" + HardSoftScore.class.getName() + ">");
        objectEditor.onPlanningSolutionScoreTypeChange();
        DataObject dataObject = this.context.getDataObject();
        Assert.assertEquals((Object)(AbstractSolution.class.getName() + "<" + BendableScore.class.getName() + ">"), (Object)dataObject.getSuperClassName());
        Method getScoreMethod = dataObject.getMethod("getScore", Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)getScoreMethod);
        Assert.assertEquals((Object)BendableScore.class.getName(), (Object)getScoreMethod.getReturnType().getName());
        Method setScoreMethod = dataObject.getMethod("setScore", Arrays.asList(BendableScore.class.getName()));
        Assert.assertNotNull((Object)setScoreMethod);
    }

    @Test
    public void onPlanningSolutionBendableScoreHardLevelsSizeChange() {
        this.testPlanningSolutionLevelsSizeChange(true);
    }

    @Test
    public void onPlanningSolutionBendableScoreSoftLevelsSizeChange() {
        this.testPlanningSolutionLevelsSizeChange(false);
    }

    public void testPlanningSolutionLevelsSizeChange(boolean isHardScore) {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningSolution.class, null, null));
        AnnotationDefinition planningScoreAnnotationDefinition = (AnnotationDefinition)Mockito.mock(AnnotationDefinition.class);
        Mockito.when((Object)planningScoreAnnotationDefinition.getClassName()).thenReturn((Object)PlanningScore.class.getName());
        this.context.getAnnotationDefinitions().put("org.optaplanner.core.api.domain.solution.PlanningScore", planningScoreAnnotationDefinition);
        this.context.getAnnotationDefinitions().put(Generated.class.getName(), Mockito.mock(AnnotationDefinition.class));
        TypeImpl getScoreMethodReturnType = new TypeImpl(BendableScore.class.getName());
        MethodImpl getScoreMethod = new MethodImpl("getScore", Collections.EMPTY_LIST, "return score;", (Type)getScoreMethodReturnType, Visibility.PUBLIC);
        getScoreMethod.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningScore.class, (Pair[])new Pair[]{new Pair((Object)"bendableHardLevelsSize", (Object)5), new Pair((Object)"bendableSoftLevelsSize", (Object)5)}));
        getScoreMethod.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(Generated.class, null, null));
        dataObject.addMethod((Method)getScoreMethod);
        ParameterImpl setScoreParameter = new ParameterImpl((Type)new TypeImpl(BendableScore.class.getName()), "score");
        TypeImpl setScoreParameterReturnType = new TypeImpl(Void.TYPE.getName());
        MethodImpl setScoreMethod = new MethodImpl("setScore", Arrays.asList(setScoreParameter), "this.score = score;", (Type)setScoreParameterReturnType, Visibility.PUBLIC);
        setScoreMethod.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(Generated.class, null, null));
        dataObject.addMethod((Method)setScoreMethod);
        if (isHardScore) {
            Mockito.when((Object)this.view.getPlanningSolutionBendableScoreHardLevelsSize()).thenReturn((Object)1);
        } else {
            Mockito.when((Object)this.view.getPlanningSolutionBendableScoreSoftLevelsSize()).thenReturn((Object)1);
        }
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)BendableScore.class.getName());
        objectEditor.onPlanningSolutionBendableScoreHardLevelsSizeChange();
        getScoreMethod = dataObject.getMethod("getScore", Collections.EMPTY_LIST);
        Assert.assertNotNull((Object)getScoreMethod);
        Annotation planningScoreAnnotation = getScoreMethod.getAnnotation(PlanningScore.class.getName());
        Assert.assertNotNull((Object)planningScoreAnnotation);
        if (isHardScore) {
            Assert.assertEquals((Object)1, (Object)planningScoreAnnotation.getValue("bendableHardLevelsSize"));
        } else {
            Assert.assertEquals((Object)1, (Object)planningScoreAnnotation.getValue("bendableSoftLevelsSize"));
        }
    }
}

