/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.validation;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationMessageTranslator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalToBeRemovedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeNotRecognizedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeToBeChangedMessage;

@ApplicationScoped
public class PlannerValidationMessageTranslator
implements ValidationMessageTranslator {
    private TranslationService translationService;

    @Inject
    public PlannerValidationMessageTranslator(TranslationService translationService) {
        this.translationService = translationService;
    }

    public boolean accept(ValidationMessage message) {
        return message instanceof PlanningSolutionToBeDuplicatedMessage || message instanceof ScoreHolderGlobalToBeRemovedMessage || message instanceof ScoreHolderGlobalTypeToBeChangedMessage || message instanceof ScoreHolderGlobalTypeNotRecognizedMessage;
    }

    public ValidationMessage translate(ValidationMessage messageToTranslate) {
        if (messageToTranslate instanceof PlanningSolutionToBeDuplicatedMessage) {
            return this.getMessageTranslation(messageToTranslate, "PlannerCheckTranslator.MultiplePlanningSolutionsToBeCreated");
        }
        if (messageToTranslate instanceof ScoreHolderGlobalToBeRemovedMessage) {
            return this.getMessageTranslation(messageToTranslate, "PlannerCheckTranslator.ScoreHolderGlobalToBeDeleted");
        }
        if (messageToTranslate instanceof ScoreHolderGlobalTypeToBeChangedMessage) {
            return this.getMessageTranslation(messageToTranslate, "PlannerCheckTranslator.ScoreHolderGlobalToBeChanged");
        }
        if (messageToTranslate instanceof ScoreHolderGlobalTypeNotRecognizedMessage) {
            return this.getMessageTranslation(messageToTranslate, "PlannerCheckTranslator.ScoreHolderGlobalTypeNotRecognized");
        }
        throw new IllegalStateException("No translation found for message " + messageToTranslate);
    }

    private ValidationMessage getMessageTranslation(ValidationMessage messageToTranslate, String translationKey) {
        ValidationMessage translatedMessage = new ValidationMessage(messageToTranslate);
        translatedMessage.setText(this.translationService.getTranslation(translationKey));
        return translatedMessage;
    }
}

