/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.handlers.planner;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ResourceOptions;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.handlers.planner.ComparatorDefinitionAnnotationValueHandler;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;

@ApplicationScoped
public class PlannerDomainHandler
implements DomainHandler {
    private Caller<ComparatorDefinitionService> comparatorDefinitionService;

    public PlannerDomainHandler() {
    }

    @Inject
    public PlannerDomainHandler(Caller<ComparatorDefinitionService> comparatorDefinitionService) {
        this.comparatorDefinitionService = comparatorDefinitionService;
    }

    public String getName() {
        return "PLANNER";
    }

    public int getPriority() {
        return 5;
    }

    public ResourceOptions getResourceOptions(boolean newInstance) {
        return null;
    }

    public void postCommandProcessing(DataModelCommand command) {
    }

    public void onDataModelerValueChangeEvent(@Observes DataModelerValueChangeEvent event) {
        this.handleDataModelerEvent((DataModelerEvent)event);
    }

    public void onDataObjectFieldDeletedEvent(@Observes DataObjectFieldDeletedEvent event) {
        this.handleDataModelerEvent((DataModelerEvent)event);
    }

    private void handleDataModelerEvent(DataModelerEvent event) {
        DataObject dataObject = event.getCurrentDataObject();
        if (dataObject != null && dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null) {
            if (dataObject.getNestedClasses() == null || dataObject.getNestedClasses().isEmpty()) {
                return;
            }
            List<JavaClass> comparatorObjects = this.getComparatorNestedClasses(dataObject);
            for (JavaClass comparatorObject : comparatorObjects) {
                boolean remove;
                ListIterator<Annotation> iterator;
                List<Annotation> objectProperties;
                Annotation objectPropertyPath;
                ListIterator<Annotation> objectPropertyPathListIterator;
                List<Annotation> objectPropertyPaths;
                ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler;
                boolean changed;
                Annotation comparatorDefinition = comparatorObject.getAnnotation(ComparatorDefinition.class.getName());
                if (event instanceof DataObjectFieldDeletedEvent) {
                    changed = false;
                    comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinition);
                    objectPropertyPaths = comparatorAnnotationHandler.getObjectPropertyPaths();
                    objectPropertyPathListIterator = objectPropertyPaths.listIterator();
                    while (objectPropertyPathListIterator.hasNext()) {
                        objectPropertyPath = objectPropertyPathListIterator.next();
                        objectProperties = comparatorAnnotationHandler.getObjectProperties(objectPropertyPath);
                        iterator = objectProperties.listIterator();
                        remove = false;
                        if (iterator.hasNext()) {
                            Annotation field = iterator.next();
                            if (event.getCurrentField().getName().equals(comparatorAnnotationHandler.getName(field))) {
                                changed = true;
                                remove = true;
                                iterator.remove();
                            }
                        }
                        if (!remove) continue;
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.remove();
                        }
                        if (!objectProperties.isEmpty()) continue;
                        objectPropertyPathListIterator.remove();
                    }
                    if (!changed) continue;
                    ((ComparatorDefinitionService)this.comparatorDefinitionService.call(this.getRemoteCallback(dataObject, comparatorObject))).updateComparatorObject(dataObject, comparatorObject);
                    continue;
                }
                if (event instanceof DataObjectChangeEvent) {
                    if (((DataObjectChangeEvent)event).getChangeType() != ChangeType.OBJECT_NAME_CHANGE && ((DataObjectChangeEvent)event).getChangeType() != ChangeType.PACKAGE_NAME_CHANGE && ((DataObjectChangeEvent)event).getChangeType() != ChangeType.CLASS_NAME_CHANGE) continue;
                    Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
                    planningEntityAnnotation.setValue("difficultyComparatorClass", (Object)(dataObject.getName() + ".DifficultyComparator.class"));
                    ((ComparatorDefinitionService)this.comparatorDefinitionService.call(this.getRemoteCallback(dataObject, comparatorObject))).updateComparatorObject(dataObject, comparatorObject);
                    continue;
                }
                if (!(event instanceof DataObjectFieldChangeEvent)) continue;
                if (((DataObjectFieldChangeEvent)event).getChangeType() == ChangeType.FIELD_NAME_CHANGE) {
                    ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler2 = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinition);
                    List<Annotation> objectPropertyPaths2 = comparatorAnnotationHandler2.getObjectPropertyPaths();
                    ListIterator<Annotation> objectPropertyPathListIterator2 = objectPropertyPaths2.listIterator();
                    boolean changed2 = false;
                    while (objectPropertyPathListIterator2.hasNext()) {
                        objectPropertyPath = objectPropertyPathListIterator2.next();
                        objectProperties = comparatorAnnotationHandler2.getObjectProperties(objectPropertyPath);
                        if (objectProperties.isEmpty() || !((DataObjectFieldChangeEvent)event).getOldValue().equals(comparatorAnnotationHandler2.getName(objectProperties.get(0)))) continue;
                        comparatorAnnotationHandler2.setName(objectProperties.get(0), (String)((DataObjectFieldChangeEvent)event).getNewValue());
                        changed2 = true;
                    }
                    if (!changed2) continue;
                    ((ComparatorDefinitionService)this.comparatorDefinitionService.call(this.getRemoteCallback(dataObject, comparatorObject))).updateComparatorObject(dataObject, comparatorObject);
                    continue;
                }
                if (((DataObjectFieldChangeEvent)event).getChangeType() != ChangeType.FIELD_TYPE_CHANGE) continue;
                changed = false;
                comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinition);
                objectPropertyPaths = comparatorAnnotationHandler.getObjectPropertyPaths();
                objectPropertyPathListIterator = objectPropertyPaths.listIterator();
                while (objectPropertyPathListIterator.hasNext()) {
                    objectPropertyPath = objectPropertyPathListIterator.next();
                    objectProperties = comparatorAnnotationHandler.getObjectProperties(objectPropertyPath);
                    iterator = objectProperties.listIterator();
                    remove = false;
                    if (iterator.hasNext()) {
                        Annotation objectProperty = iterator.next();
                        if (event.getCurrentField().getName().equals(comparatorAnnotationHandler.getName(objectProperty))) {
                            comparatorAnnotationHandler.setType(objectProperty, (String)((DataObjectFieldChangeEvent)event).getNewValue());
                            changed = true;
                            remove = true;
                        }
                    }
                    if (!remove) continue;
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    if (!objectProperties.isEmpty()) continue;
                    objectPropertyPathListIterator.remove();
                }
                if (!changed) continue;
                ((ComparatorDefinitionService)this.comparatorDefinitionService.call(this.getRemoteCallback(dataObject, comparatorObject))).updateComparatorObject(dataObject, comparatorObject);
            }
        }
    }

    private RemoteCallback<JavaClass> getRemoteCallback(final DataObject dataObject, final JavaClass currentComparatorObject) {
        return new RemoteCallback<JavaClass>(){

            public void callback(JavaClass updatedComparatorObject) {
                dataObject.removeNestedClass(currentComparatorObject);
                dataObject.addNestedClass(updatedComparatorObject);
            }
        };
    }

    private List<JavaClass> getComparatorNestedClasses(DataObject dataObject) {
        String difficultyComparatorClass;
        Annotation planningEntityAnnotation = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
        if (dataObject.getNestedClasses() != null && planningEntityAnnotation != null && (difficultyComparatorClass = (String)planningEntityAnnotation.getValue("difficultyComparatorClass")) != null && difficultyComparatorClass.matches("\\w[\\.\\w]+\\.class")) {
            String[] difficultyComparatorTokens = difficultyComparatorClass.split("\\.");
            return dataObject.getNestedClasses().stream().filter(t -> t.getName().equals(difficultyComparatorTokens[difficultyComparatorTokens.length - 2]) && t.getAnnotation(ComparatorDefinition.class.getName()) != null && t.getAnnotation("javax.annotation.Generated") != null && t.getInterfaces().stream().anyMatch(i -> i.startsWith(Comparator.class.getName()))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isDomainSpecificProperty(ObjectProperty objectProperty) {
        return objectProperty != null && "score".equals(objectProperty.getName()) && objectProperty.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningScore") != null;
    }
}

