/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.util.ErrorPopupHelper;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.workbench.screens.domaineditor.client.handlers.planner.ComparatorDefinitionAnnotationValueHandler;
import org.optaplanner.workbench.screens.domaineditor.client.resources.i18n.DomainEditorLookupConstants;
import org.optaplanner.workbench.screens.domaineditor.client.util.PlannerDomainTypes;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Pair;

@Dependent
public class PlannerDataObjectEditor
extends ObjectEditor
implements PlannerDataObjectEditorView.Presenter {
    private PlannerDataObjectEditorView view;
    private TranslationService translationService;
    private JavaClass comparatorObject;
    private Caller<ComparatorDefinitionService> comparatorDefinitionService;
    private Caller<DataModelerService> dataModelerService;

    @Inject
    public PlannerDataObjectEditor(PlannerDataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, TranslationService translationService, Caller<ComparatorDefinitionService> comparatorDefinitionService, Caller<DataModelerService> dataModelerService) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        this.translationService = translationService;
        this.comparatorDefinitionService = comparatorDefinitionService;
        this.dataModelerService = dataModelerService;
        view.init(this);
        view.initPlanningSolutionScoreTypeOptions(this.getPlanningSolutionScoreTypeOptions());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String getName() {
        return "PLANNER_OBJECT_EDITOR";
    }

    public String getDomainName() {
        return "PLANNER_DOMAIN";
    }

    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.dataObject = dataObject;
        this.comparatorObject = null;
        if (dataObject != null) {
            ObjectProperty scoreObjectProperty;
            boolean hasPlanningSolution;
            boolean hasPlanningEntity = dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity") != null;
            boolean bl = hasPlanningSolution = dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null;
            if (!hasPlanningSolution) {
                this.view.enablePlanningSolutionCheckBox(false);
                this.view.showPlanningSolutionHelpIcon(false);
                ((DataModelerService)this.dataModelerService.call(this.getFindClassUsagesCallback())).findClassUsages(this.context.getCurrentProject().getRootPath(), "org.optaplanner.core.api.domain.solution.PlanningSolution");
            } else {
                this.view.enablePlanningSolutionCheckBox(true);
                this.view.showPlanningSolutionHelpIcon(false);
                this.adjustSelectedPlanningSolutionScoreType();
            }
            this.view.setPlanningEntityValue(hasPlanningEntity);
            this.view.setPlanningSolutionValue(hasPlanningSolution);
            this.view.showPlanningSolutionScoreType(hasPlanningSolution);
            this.view.setNotInPlanningValue(!hasPlanningEntity && !hasPlanningSolution);
            this.view.destroyFieldPicker();
            this.view.showPlanningSolutionBendableScoreInput(false);
            if (hasPlanningEntity) {
                if (!dataObject.getNestedClasses().isEmpty()) {
                    for (JavaClass javaClass : dataObject.getNestedClasses()) {
                        if (javaClass.getAnnotation(ComparatorDefinition.class.getName()) == null) continue;
                        try {
                            this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), this.getObjectPropertyPathList(javaClass.getAnnotation(ComparatorDefinition.class.getName())));
                            this.comparatorObject = javaClass;
                            break;
                        }
                        catch (IllegalStateException e) {
                            ErrorPopupHelper.showErrorPopup((String)(this.translationService.getTranslation("PlannerDataObjectEditor.ComparatorDefinitionProcessingFailed") + " " + e.getMessage()));
                        }
                    }
                } else {
                    this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), null);
                }
            }
            if (hasPlanningSolution && (scoreObjectProperty = dataObject.getProperty("score")) != null) {
                if (this.isBendableScore(scoreObjectProperty.getClassName())) {
                    this.view.showPlanningSolutionBendableScoreInput(true);
                    Annotation annotation = scoreObjectProperty.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningScore");
                    if (annotation != null) {
                        Object hardLevelsSize = annotation.getValue("bendableHardLevelsSize");
                        if (hardLevelsSize != null) {
                            this.view.setPlanningSolutionBendableScoreHardLevelsSize((Integer)hardLevelsSize == -1 ? 0 : (Integer)hardLevelsSize);
                        } else {
                            this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                        }
                        Object softLevelsSize = annotation.getValue("bendableSoftLevelsSize");
                        if (softLevelsSize != null) {
                            this.view.setPlanningSolutionBendableScoreSoftLevelsSize((Integer)softLevelsSize == -1 ? 0 : (Integer)softLevelsSize);
                        } else {
                            this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                        }
                    }
                } else {
                    this.view.showPlanningSolutionBendableScoreInput(false);
                    this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                    this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                }
            }
        }
    }

    RemoteCallback<List<Path>> getFindClassUsagesCallback() {
        return new RemoteCallback<List<Path>>(){

            public void callback(List<Path> paths) {
                ArrayList<Path> pathsCopy = new ArrayList<Path>(paths);
                Path currentDataObjectPath = PlannerDataObjectEditor.this.context.getDataObjectPath(PlannerDataObjectEditor.this.dataObject.getClassName());
                pathsCopy.remove(currentDataObjectPath);
                PlannerDataObjectEditor.this.view.enablePlanningSolutionCheckBox(pathsCopy.isEmpty());
                PlannerDataObjectEditor.this.view.showPlanningSolutionHelpIcon(!pathsCopy.isEmpty());
            }
        };
    }

    private List<ObjectPropertyPath> getObjectPropertyPathList(Annotation comparatorDefinition) {
        ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinition);
        ArrayList<ObjectPropertyPath> objectPropertyPathList = new ArrayList<ObjectPropertyPath>();
        List<Annotation> comparatorFieldPaths = comparatorAnnotationHandler.getObjectPropertyPaths();
        for (Annotation comparatorFieldPath : comparatorFieldPaths) {
            ObjectPropertyPathImpl objectPropertyPath = new ObjectPropertyPathImpl();
            objectPropertyPath.setDescending(!comparatorAnnotationHandler.isAscending(comparatorFieldPath));
            List<Annotation> comparatorFields = comparatorAnnotationHandler.getObjectProperties(comparatorFieldPath);
            if (!comparatorFields.isEmpty()) {
                String objectPropertyName = comparatorAnnotationHandler.getName(comparatorFields.get(0));
                ObjectProperty objectProperty = this.dataObject.getProperty(objectPropertyName);
                if (objectProperty == null) {
                    throw new IllegalStateException(this.dataObject.getName() + "Comparator: Property " + objectPropertyName + " not found in data object " + this.dataObject.getClassName());
                }
                objectPropertyPath.appendObjectProperty(objectProperty);
                for (int i = 1; i < comparatorFields.size(); ++i) {
                    objectPropertyName = comparatorAnnotationHandler.getName(comparatorFields.get(i));
                    ObjectProperty lastObjectPropertyInPath = (ObjectProperty)objectPropertyPath.getObjectPropertyPath().get(objectPropertyPath.getObjectPropertyPath().size() - 1);
                    if (lastObjectPropertyInPath.isBaseType() || lastObjectPropertyInPath.isPrimitiveType()) {
                        throw new IllegalStateException(this.dataObject.getName() + "Comparator: Cannot append property " + objectPropertyName + " to primitive/base type " + lastObjectPropertyInPath.getClassName());
                    }
                    DataObject lastDataObjectInPath = this.getContext().getDataModel().getDataObject(lastObjectPropertyInPath.getClassName());
                    if (lastObjectPropertyInPath == null) {
                        throw new IllegalStateException(this.dataObject.getName() + "Comparator: Data object " + lastObjectPropertyInPath.getClassName() + " not found");
                    }
                    ObjectProperty currentObjectProperty = lastDataObjectInPath.getProperty(objectPropertyName);
                    if (currentObjectProperty == null) {
                        throw new IllegalStateException(this.dataObject.getName() + "Comparator: Property " + objectPropertyName + " not found in data object " + lastDataObjectInPath.getClassName());
                    }
                    objectPropertyPath.appendObjectProperty(currentObjectProperty);
                }
            }
            objectPropertyPathList.add((ObjectPropertyPath)objectPropertyPath);
        }
        return objectPropertyPathList;
    }

    private boolean isBendableScore(String planningSolutionScoreType) {
        return BendableScore.class.getName().equals(planningSolutionScoreType) || BendableLongScore.class.getName().equals(planningSolutionScoreType) || BendableBigDecimalScore.class.getName().equals(planningSolutionScoreType);
    }

    public void clear() {
        this.view.clear();
        this.view.setNotInPlanningValue(true);
    }

    @Override
    public void objectPropertyPathChanged(List<ObjectPropertyPath> objectPropertyPaths, boolean itemsRemoved) {
        if (objectPropertyPaths.isEmpty() && this.view.isFieldPickerEmpty() && itemsRemoved) {
            this.commandBuilder.buildDataObjectRemoveNestedClassCommand(this.context, this.getName(), this.dataObject, this.comparatorObject).execute();
            this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.comparatorObject = null;
            this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), Collections.EMPTY_LIST);
            return;
        }
        if (this.comparatorObject != null) {
            this.comparatorObject.removeAnnotation(ComparatorDefinition.class.getName());
            this.comparatorObject.addAnnotation(ComparatorDefinitionAnnotationValueHandler.createAnnotation(objectPropertyPaths, this.context.getAnnotationDefinitions()));
            ((ComparatorDefinitionService)this.comparatorDefinitionService.call((RemoteCallback)new RemoteCallback<JavaClass>(){

                public void callback(JavaClass updatedComparatorObject) {
                    PlannerDataObjectEditor.this.dataObject.removeNestedClass(PlannerDataObjectEditor.this.comparatorObject);
                    PlannerDataObjectEditor.this.dataObject.addNestedClass(updatedComparatorObject);
                    PlannerDataObjectEditor.this.comparatorObject = updatedComparatorObject;
                }
            })).updateComparatorObject(this.dataObject, this.comparatorObject);
        } else {
            ((ComparatorDefinitionService)this.comparatorDefinitionService.call((RemoteCallback)new RemoteCallback<JavaClass>(){

                public void callback(JavaClass newComparatorObject) {
                    PlannerDataObjectEditor.this.dataObject.addNestedClass(newComparatorObject);
                    PlannerDataObjectEditor.this.comparatorObject = newComparatorObject;
                }
            })).createComparatorObject(this.dataObject);
        }
        List<ValuePair> valuePairList = Arrays.asList(new ValuePair("difficultyComparatorClass", (Object)(this.getDataObject().getName() + ".DifficultyComparator.class")));
        this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity", valuePairList).execute();
    }

    @Override
    public void removeComparatorDefinition(DataObject dataObject, boolean resetPlanningEntityAnnotation) {
        if (this.comparatorObject != null) {
            this.commandBuilder.buildDataObjectRemoveNestedClassCommand(this.getContext(), this.getName(), dataObject, this.comparatorObject).execute();
            this.comparatorObject = null;
        }
        this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), ComparatorDefinition.class.getName()).execute();
        if (resetPlanningEntityAnnotation) {
            this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
        }
    }

    @Override
    public void onNotInPlanningChange() {
        boolean value = this.view.getNotInPlanningValue();
        if (value && this.dataObject != null) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
            if (this.isPlanningSolution(this.getDataObject())) {
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
            }
            this.removeComparatorDefinition(this.getDataObject(), false);
            this.view.destroyFieldPicker();
            this.view.showPlanningSolutionScoreType(false);
            this.view.showPlanningSolutionBendableScoreInput(false);
            this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
            this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
            this.removePlanningSolutionMarshalingAnnotations();
            this.removePlanningScoreProperty();
        }
    }

    @Override
    public void onPlanningEntityChange() {
        boolean value = this.view.getPlanningEntityValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                if (this.isPlanningSolution(this.getDataObject())) {
                    this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
                }
                this.view.initFieldPicker(this.getContext().getDataModel(), this.getDataObject(), null);
                this.view.showPlanningSolutionScoreType(false);
                this.view.showPlanningSolutionBendableScoreInput(false);
                this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                this.removePlanningSolutionMarshalingAnnotations();
                this.removePlanningScoreProperty();
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
            }
        }
    }

    @Override
    public void onPlanningSolutionChange() {
        boolean value = this.view.getPlanningSolutionValue();
        if (this.dataObject != null) {
            if (value) {
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution", Arrays.asList(new ValuePair("autoDiscoverMemberType", (Object)"FIELD"))).execute();
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "javax.xml.bind.annotation.XmlRootElement").execute();
                this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "javax.xml.bind.annotation.XmlAccessorType", Arrays.asList(new ValuePair("value", (Object)"FIELD"))).execute();
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.entity.PlanningEntity").execute();
                this.removeComparatorDefinition(this.getDataObject(), false);
                this.view.destroyFieldPicker();
                this.view.showPlanningSolutionScoreType(true);
                this.view.setPlanningSolutionScoreType(this.getDefaultSolutionScoreType());
                this.updatePlanningScoreProperty(this.view.getPlanningSolutionScoreType());
            } else {
                this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.optaplanner.core.api.domain.solution.PlanningSolution").execute();
                this.view.showPlanningSolutionScoreType(false);
                this.view.showPlanningSolutionBendableScoreInput(false);
                this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
                this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
                this.removePlanningSolutionMarshalingAnnotations();
                this.removePlanningScoreProperty();
            }
        }
    }

    @Override
    public void onPlanningSolutionScoreTypeChange() {
        this.updatePlanningScoreProperty(this.view.getPlanningSolutionScoreType());
    }

    @Override
    public void onPlanningSolutionBendableScoreHardLevelsSizeChange() {
        this.updateBendableScoreLevelsSize();
    }

    @Override
    public void onPlanningSolutionBendableScoreSoftLevelsSizeChange() {
        this.updateBendableScoreLevelsSize();
    }

    private void updateBendableScoreLevelsSize() {
        ObjectProperty scoreObjectProperty = this.dataObject.getProperty("score");
        if (scoreObjectProperty != null) {
            List<ValuePair> valuePairList = Arrays.asList(new ValuePair("bendableHardLevelsSize", (Object)this.view.getPlanningSolutionBendableScoreHardLevelsSize()), new ValuePair("bendableSoftLevelsSize", (Object)this.view.getPlanningSolutionBendableScoreSoftLevelsSize()));
            this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), scoreObjectProperty, "org.optaplanner.core.api.domain.solution.PlanningScore", valuePairList).execute();
        }
    }

    void updatePlanningScoreProperty(String newPlanningSolutionScoreType) {
        if (this.getDataObject() != null) {
            this.removePlanningScoreProperty();
            this.addPlanningScoreProperty(newPlanningSolutionScoreType);
        }
    }

    private void removePlanningSolutionMarshalingAnnotations() {
        if (this.dataObject != null) {
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "javax.xml.bind.annotation.XmlRootElement").execute();
            this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "javax.xml.bind.annotation.XmlAccessorType").execute();
        }
    }

    private void removePlanningScoreProperty() {
        ObjectProperty scoreProperty = this.dataObject.getProperty("score");
        if (scoreProperty != null) {
            this.commandBuilder.buildRemovePropertyCommand(this.getContext(), this.getName(), this.getDataObject(), "score").execute();
        }
    }

    private void addPlanningScoreProperty(String newPlanningSolutionScoreType) {
        if (newPlanningSolutionScoreType.isEmpty()) {
            return;
        }
        this.commandBuilder.buildAddPropertyCommand(this.getContext(), this.getName(), this.getDataObject(), "score", "Generated Planner score field", newPlanningSolutionScoreType, Boolean.valueOf(false)).execute();
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getDataObject().getProperty("score"), "javax.annotation.Generated", Arrays.asList(new ValuePair("value", Arrays.asList(PlannerDataObjectEditor.class.getName())))).execute();
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getDataObject().getProperty("score"), "org.optaplanner.core.api.domain.solution.PlanningScore").execute();
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getDataObject().getProperty("score"), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter", Arrays.asList(new ValuePair("value", (Object)(this.resolveXmlAdapterClass(newPlanningSolutionScoreType) + ".class")))).execute();
        this.view.setPlanningSolutionBendableScoreHardLevelsSize(0);
        this.view.setPlanningSolutionBendableScoreSoftLevelsSize(0);
        if (this.isBendableScore(newPlanningSolutionScoreType)) {
            this.view.showPlanningSolutionBendableScoreInput(true);
            List<ValuePair> valuePairList = Arrays.asList(new ValuePair("bendableHardLevelsSize", (Object)this.view.getPlanningSolutionBendableScoreHardLevelsSize()), new ValuePair("bendableSoftLevelsSize", (Object)this.view.getPlanningSolutionBendableScoreSoftLevelsSize()));
            this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getDataObject().getProperty("score"), "org.optaplanner.core.api.domain.solution.PlanningScore", valuePairList).execute();
        } else {
            this.view.showPlanningSolutionBendableScoreInput(false);
        }
    }

    private String resolveXmlAdapterClass(String scoreType) {
        return PlannerDomainTypes.SCORE_CONFIGURATION_MAP.entrySet().stream().filter(e -> ((Class)e.getKey()).getName().equals(scoreType)).map(c -> ((PlannerDomainTypes.ScoreConfigurationHolder)c.getValue()).getJaxbXmlAdapterClass()).findAny().orElseThrow(() -> new IllegalArgumentException("Score type " + scoreType + " not recognized."));
    }

    private boolean isPlanningSolution(DataObject dataObject) {
        return dataObject != null && dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null;
    }

    private List<Pair<String, String>> getPlanningSolutionScoreTypeOptions() {
        return PlannerDomainTypes.SCORE_CONFIGURATION_MAP.keySet().stream().map(s -> new Pair((Object)DomainEditorLookupConstants.INSTANCE.getString(s.getSimpleName()), (Object)s.getName())).collect(Collectors.toList());
    }

    private void adjustSelectedPlanningSolutionScoreType() {
        if (this.getDataObject() != null) {
            ObjectProperty scoreObjectProperty = this.getDataObject().getProperty("score");
            this.view.setPlanningSolutionScoreType(scoreObjectProperty == null ? "" : scoreObjectProperty.getClassName());
        }
    }

    private String getDefaultSolutionScoreType() {
        return HardSoftScore.class.getName();
    }
}

