/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPicker;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItem;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditor;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataObjectFieldPickerTest {
    @Mock
    private DataObjectFieldPickerView view;
    @Mock
    private ManagedInstance<DataObjectFieldPickerItem> fieldPickerItemProducer;
    @Mock
    private PlannerDataObjectEditor editor;
    private DataObjectFieldPicker fieldPicker;

    @Before
    public void setUp() {
        this.fieldPicker = new DataObjectFieldPicker(this.view, this.fieldPickerItemProducer);
    }

    @Test
    public void setPresenter() {
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPresenter((DataObjectFieldPickerView.Presenter)this.fieldPicker);
    }

    @Test
    public void initWhenComparatorObjectSpecified() {
        this.initFieldPicker();
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displayComparatorCheckbox(true);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displayFieldPicker(true);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setComparatorCheckboxValue(true);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void initWhenComparatorObjectNotSpecified() {
        this.fieldPicker.init((DataModel)Mockito.mock(DataModel.class), (DataObject)Mockito.mock(DataObject.class), null, (PlannerDataObjectEditorView.Presenter)this.editor);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displayComparatorCheckbox(true);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).displayFieldPicker(Matchers.anyBoolean());
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setComparatorCheckboxValue(Matchers.anyBoolean());
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void addFieldPickerItem() {
        this.initFieldPicker();
        Mockito.when((Object)this.fieldPickerItemProducer.get()).thenReturn(Mockito.mock(DataObjectFieldPickerItem.class));
        this.fieldPicker.addFieldPickerItem();
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addFieldPickerItem((DataObjectFieldPickerItem)Matchers.any(DataObjectFieldPickerItem.class));
    }

    @Test
    public void onFieldPickerItemRemoved() {
        this.initFieldPicker();
        DataObjectFieldPickerItem item = new DataObjectFieldPickerItem((DataObjectFieldPickerItemView)Mockito.mock(DataObjectFieldPickerItemView.class));
        Mockito.when((Object)this.fieldPickerItemProducer.get()).thenReturn((Object)item);
        this.fieldPicker.addFieldPickerItem();
        this.fieldPicker.onFieldPickerItemRemoved(item);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).removeFieldPickerItem(Matchers.anyInt());
        ((PlannerDataObjectEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)1))).objectPropertyPathChanged(Matchers.anyList(), Matchers.eq((boolean)true));
    }

    @Test
    public void onMoveFieldPickerItemUp() {
        this.initFieldPicker();
        this.fieldPicker.onMoveFieldPickerItemUp((DataObjectFieldPickerItem)Matchers.any(DataObjectFieldPickerItem.class));
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).moveFieldItemUp(Matchers.anyInt());
    }

    @Test
    public void onMoveFieldPickerItemDown() {
        this.initFieldPicker();
        this.fieldPicker.onMoveFieldPickerItemDown((DataObjectFieldPickerItem)Matchers.any(DataObjectFieldPickerItem.class));
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).moveFieldItemDown(Matchers.anyInt());
    }

    @Test
    public void destroy() {
        this.fieldPicker.destroy();
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displayFieldPicker(false);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displayComparatorCheckbox(false);
        ((DataObjectFieldPickerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    private void initFieldPicker() {
        this.fieldPicker.init((DataModel)Mockito.mock(DataModel.class), (DataObject)Mockito.mock(DataObject.class), Collections.EMPTY_LIST, (PlannerDataObjectEditorView.Presenter)this.editor);
    }
}

