/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.validation;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationMessageTranslator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningScoreToBeDeletedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalFileToBeRemovedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalToBeDefinedManuallyMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalToBeRemovedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeNotRecognizedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeToBeChangedMessage;

@ApplicationScoped
public class PlannerValidationMessageTranslator
implements ValidationMessageTranslator {
    private TranslationService translationService;
    private static Map<String, String> MESSAGE_CLASS_KEY_MAPPING = new HashMap<String, String>();

    @Inject
    public PlannerValidationMessageTranslator(TranslationService translationService) {
        this.translationService = translationService;
    }

    public boolean accept(ValidationMessage message) {
        return MESSAGE_CLASS_KEY_MAPPING.containsKey(message.getClass().getName());
    }

    public ValidationMessage translate(ValidationMessage messageToTranslate) {
        String translationKey = MESSAGE_CLASS_KEY_MAPPING.get(messageToTranslate.getClass().getName());
        if (translationKey == null) {
            throw new IllegalStateException("No translation found for message " + messageToTranslate);
        }
        return this.getMessageTranslation(messageToTranslate, translationKey);
    }

    private ValidationMessage getMessageTranslation(ValidationMessage messageToTranslate, String translationKey) {
        ValidationMessage translatedMessage = new ValidationMessage(messageToTranslate);
        translatedMessage.setText(this.translationService.getTranslation(translationKey));
        return translatedMessage;
    }

    static {
        MESSAGE_CLASS_KEY_MAPPING.put(PlanningSolutionToBeDuplicatedMessage.class.getName(), "PlannerCheckTranslator.MultiplePlanningSolutionsToBeCreated");
        MESSAGE_CLASS_KEY_MAPPING.put(ScoreHolderGlobalToBeRemovedMessage.class.getName(), "PlannerCheckTranslator.ScoreHolderGlobalToBeDeleted");
        MESSAGE_CLASS_KEY_MAPPING.put(ScoreHolderGlobalTypeToBeChangedMessage.class.getName(), "PlannerCheckTranslator.ScoreHolderGlobalToBeChanged");
        MESSAGE_CLASS_KEY_MAPPING.put(ScoreHolderGlobalTypeNotRecognizedMessage.class.getName(), "PlannerCheckTranslator.ScoreHolderGlobalTypeNotRecognized");
        MESSAGE_CLASS_KEY_MAPPING.put(ScoreHolderGlobalFileToBeRemovedMessage.class.getName(), "PlannerCheckTranslator.ScoreHolderGlobalFileToBeRemovedMessage");
        MESSAGE_CLASS_KEY_MAPPING.put(ScoreHolderGlobalToBeDefinedManuallyMessage.class.getName(), "PlannerCheckTranslator.ScoreHolderGlobalToBeDefinedManuallyMessage");
        MESSAGE_CLASS_KEY_MAPPING.put(PlanningScoreToBeDeletedMessage.class.getName(), "PlannerCheckTranslator.PlanningScoreToBeDeletedMessage");
    }
}

