/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import javax.annotation.Generated;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.workbench.screens.domaineditor.client.editor.PlannerFieldMetadataProvider;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlannerFieldMetadataProviderTest {
    @Mock
    private TranslationService translationService;
    private PlannerFieldMetadataProvider fieldMetadataProvider;

    @Before
    public void setUp() {
        Mockito.when((Object)this.translationService.getTranslation(Matchers.anyString())).thenReturn((Object)"translation");
        this.fieldMetadataProvider = new PlannerFieldMetadataProvider(this.translationService);
        this.fieldMetadataProvider.init();
    }

    @Test
    public void getFieldMetadataMatchingField() {
        AnnotationImpl planningScoreAnnotation = new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningScore.class));
        ObjectPropertyImpl matchingField = new ObjectPropertyImpl("matchingField", HardSoftScore.class.getName(), false);
        matchingField.addAnnotation((Annotation)planningScoreAnnotation);
        Optional fieldMetadata = this.fieldMetadataProvider.getFieldMetadata((ObjectProperty)matchingField);
        Assert.assertTrue((boolean)fieldMetadata.isPresent());
    }

    @Test
    public void getFieldMetadataNonMatchingField() {
        AnnotationImpl generatedAnnotation = new AnnotationImpl(DriverUtils.buildAnnotationDefinition(Generated.class));
        ObjectPropertyImpl nonMatchingField = new ObjectPropertyImpl("nonMatchingField", Integer.class.getName(), false);
        nonMatchingField.addAnnotation((Annotation)generatedAnnotation);
        Optional fieldMetadata = this.fieldMetadataProvider.getFieldMetadata((ObjectProperty)nonMatchingField);
        Assert.assertFalse((boolean)fieldMetadata.isPresent());
    }
}

