/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.NumberInput;
import org.jboss.errai.common.client.dom.Option;
import org.jboss.errai.common.client.dom.Select;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPicker;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPath;
import org.uberfire.client.views.pfly.widgets.HelpIcon;
import org.uberfire.commons.data.Pair;

@Dependent
@Templated
public class PlannerDataObjectEditorViewImpl
extends Composite
implements PlannerDataObjectEditorView {
    @Inject
    Document document;
    @Inject
    @DataField(value="notInPlanningRadioButton")
    Input notInPlanningRadioButton;
    @Inject
    @DataField(value="planningEntityRadioButton")
    Input planningEntityRadioButton;
    @Inject
    @DataField(value="planningSolutionRadioButton")
    Input planningSolutionRadioButton;
    @Inject
    @DataField(value="planningSolutionHelpIcon")
    HelpIcon planningSolutionHelpIcon;
    @Inject
    @DataField(value="planningSolutionScoreTypeGroup")
    Div planningSolutionScoreTypeGroup;
    @Inject
    @DataField(value="planningSolutionScoreTypeSelector")
    Select planningSolutionScoreTypeSelector;
    @Inject
    @DataField(value="planningSolutionBendableScoreInputGroup")
    Div planningSolutionBendableScoreInputGroup;
    @Inject
    @DataField(value="planningSolutionBendableScoreHardLevelsSizeInput")
    NumberInput planningSolutionBendableScoreHardLevelsSizeInput;
    @Inject
    @DataField(value="planningSolutionBendableScoreSoftLevelsSizeInput")
    NumberInput planningSolutionBendableScoreSoftLevelsSizeInput;
    @Inject
    @DataField(value="fieldPicker")
    DataObjectFieldPicker fieldPicker;
    @Inject
    private TranslationService translationService;
    private PlannerDataObjectEditorView.Presenter presenter;

    @PostConstruct
    public void postConstruct() {
        this.planningSolutionHelpIcon.setVisible(false);
        this.planningSolutionHelpIcon.setHelpContent(this.translationService.getTranslation("PlannerDataObjectEditorViewImpl.PlanningSolutionHelpIconContent"));
    }

    public void init(PlannerDataObjectEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setNotInPlanningValue(boolean value) {
        this.notInPlanningRadioButton.setChecked(value);
    }

    @Override
    public boolean getNotInPlanningValue() {
        return this.notInPlanningRadioButton.getChecked();
    }

    @Override
    public void setPlanningEntityValue(boolean value) {
        this.planningEntityRadioButton.setChecked(value);
    }

    @Override
    public boolean getPlanningEntityValue() {
        return this.planningEntityRadioButton.getChecked();
    }

    @Override
    public void setPlanningSolutionValue(boolean value) {
        this.planningSolutionRadioButton.setChecked(value);
    }

    @Override
    public boolean getPlanningSolutionValue() {
        return this.planningSolutionRadioButton.getChecked();
    }

    @Override
    public void enablePlanningSolutionCheckBox(boolean enable) {
        this.planningSolutionRadioButton.setDisabled(!enable);
    }

    @Override
    public void showPlanningSolutionHelpIcon(boolean show) {
        this.planningSolutionHelpIcon.setVisible(show);
    }

    @Override
    public void clear() {
        this.setNotInPlanningValue(false);
        this.setPlanningEntityValue(false);
        this.setPlanningSolutionValue(false);
    }

    @Override
    public void initFieldPicker(DataModel dataModel, DataObject rootDataObject, List<ObjectPropertyPath> objectPropertyPaths) {
        this.fieldPicker.init(dataModel, rootDataObject, objectPropertyPaths, this.presenter);
    }

    @Override
    public void destroyFieldPicker() {
        this.fieldPicker.destroy();
    }

    @Override
    public boolean isFieldPickerEmpty() {
        return this.fieldPicker.isEmpty();
    }

    @Override
    public void initPlanningSolutionScoreTypeOptions(List<Pair<String, String>> optionPairs) {
        this.planningSolutionScoreTypeSelector.add((HTMLElement)this.createOption((Pair<String, String>)Pair.newPair((Object)"-", (Object)"")));
        for (Pair<String, String> optionPair : optionPairs) {
            Option option = this.createOption(optionPair);
            this.planningSolutionScoreTypeSelector.add((HTMLElement)option);
        }
    }

    private Option createOption(Pair<String, String> optionPair) {
        Option option = (Option)this.document.createElement("option");
        option.setText((String)optionPair.getK1());
        option.setValue((String)optionPair.getK2());
        return option;
    }

    @Override
    public String getPlanningSolutionScoreType() {
        return this.planningSolutionScoreTypeSelector.getValue();
    }

    @Override
    public void showPlanningSolutionScoreType(boolean show) {
        this.planningSolutionScoreTypeGroup.setHidden(!show);
    }

    @Override
    public int getPlanningSolutionBendableScoreHardLevelsSize() {
        boolean isNumeric = this.planningSolutionBendableScoreHardLevelsSizeInput.getValue().matches("\\d+");
        if (!isNumeric) {
            this.planningSolutionBendableScoreHardLevelsSizeInput.setValue("0");
        }
        return Integer.parseInt(this.planningSolutionBendableScoreHardLevelsSizeInput.getValue());
    }

    @Override
    public void setPlanningSolutionBendableScoreHardLevelsSize(int hardLevelsSize) {
        this.planningSolutionBendableScoreHardLevelsSizeInput.setValue(String.valueOf(hardLevelsSize));
    }

    @Override
    public int getPlanningSolutionBendableScoreSoftLevelsSize() {
        boolean isNumeric = this.planningSolutionBendableScoreSoftLevelsSizeInput.getValue().matches("\\d+");
        if (!isNumeric) {
            this.planningSolutionBendableScoreSoftLevelsSizeInput.setValue("0");
        }
        return Integer.parseInt(this.planningSolutionBendableScoreSoftLevelsSizeInput.getValue());
    }

    @Override
    public void setPlanningSolutionBendableScoreSoftLevelsSize(int softLevelsSize) {
        this.planningSolutionBendableScoreSoftLevelsSizeInput.setValue(String.valueOf(softLevelsSize));
    }

    @Override
    public void showPlanningSolutionBendableScoreInput(boolean show) {
        this.planningSolutionBendableScoreInputGroup.setHidden(!show);
    }

    @Override
    public void setPlanningSolutionScoreType(String scoreType) {
        this.planningSolutionScoreTypeSelector.setValue(scoreType);
    }

    @EventHandler(value={"notInPlanningRadioButton"})
    void onNotInPlanningChange(ClickEvent event) {
        this.presenter.onNotInPlanningChange();
    }

    @EventHandler(value={"planningEntityRadioButton"})
    void onPlanningEntityChange(ClickEvent event) {
        this.presenter.onPlanningEntityChange();
    }

    @EventHandler(value={"planningSolutionRadioButton"})
    void onPlanningSolutionChange(ClickEvent event) {
        this.presenter.onPlanningSolutionChange();
    }

    @EventHandler(value={"planningSolutionScoreTypeSelector"})
    void setPlanningSolutionScoreTypeChange(ChangeEvent event) {
        this.presenter.onPlanningSolutionScoreTypeChange();
    }

    @EventHandler(value={"planningSolutionBendableScoreHardLevelsSizeInput"})
    void onPlanningSolutionBendableScoreHardLevelsSizeInputChange(ChangeEvent event) {
        this.presenter.onPlanningSolutionBendableScoreHardLevelsSizeChange();
    }

    @EventHandler(value={"planningSolutionBendableScoreSoftLevelsSizeInput"})
    void onPlanningSolutionBendableScoreSoftLevelsSizeInputChange(ChangeEvent event) {
        this.presenter.onPlanningSolutionBendableScoreSoftLevelsSizeChange();
    }
}

