/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Generated;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.client.widgets.DataModelerEditorsTestHelper;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditor;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerDataObjectEditorView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerEditorBaseTest;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.commons.data.Pair;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlannerDataObjectEditorTest
extends PlannerEditorBaseTest {
    @Mock
    private PlannerDataObjectEditorView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private Caller<ComparatorDefinitionService> comparatorDefinitionService;
    @Mock
    private Caller<AssetsUsageService> assetsUsageServiceCaller;
    @Mock
    private AssetsUsageService assetsUsageService;

    protected PlannerDataObjectEditor createObjectEditor() {
        Mockito.when((Object)this.assetsUsageServiceCaller.call((RemoteCallback)Mockito.any())).thenReturn((Object)this.assetsUsageService);
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(Mockito.anyString(), (ResourceType)Mockito.any(), (Path)Mockito.any(Path.class))).thenReturn(Collections.emptyList());
        PlannerDataObjectEditor objectEditor = new PlannerDataObjectEditor(this.view, this.handlerRegistry, this.dataModelerEvent, this.commandBuilder, this.translationService, this.comparatorDefinitionService, this.assetsUsageServiceCaller);
        return objectEditor;
    }

    @Test
    public void initEditor() {
        PlannerDataObjectEditor presenter = this.createObjectEditor();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)presenter);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initPlanningSolutionScoreTypeOptions(Mockito.anyList());
    }

    @Test
    public void loadDataObject() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningEntityValue(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionValue(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setNotInPlanningValue(true);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).destroyFieldPicker();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(false);
        ((AssetsUsageService)Mockito.verify((Object)this.assetsUsageService, (VerificationMode)Mockito.times((int)1))).getAssetUsages(Mockito.anyString(), (ResourceType)Mockito.any(), (Path)Mockito.any());
    }

    @Test
    public void loadDataObjectPlanningSolution() {
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningSolution.class, null, null));
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePlanningSolutionCheckBox(true);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionHelpIcon(false);
        ((AssetsUsageService)Mockito.verify((Object)this.assetsUsageService, (VerificationMode)Mockito.never())).getAssetUsages(Mockito.anyString(), (ResourceType)Mockito.any(), (Path)Mockito.any(Path.class));
    }

    @Test
    public void loadDataObjectWithBendableScoreType() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningSolution.class, null, null));
        ObjectPropertyImpl scoreObjectProperty = new ObjectPropertyImpl("score", BendableScore.class.getName(), false);
        dataObject.addProperty((ObjectProperty)scoreObjectProperty);
        scoreObjectProperty.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningScore.class, (Pair[])new Pair[]{new Pair((Object)"bendableHardLevelsSize", (Object)5), new Pair((Object)"bendableSoftLevelsSize", (Object)10)}));
        scoreObjectProperty.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(Generated.class, null, null));
        objectEditor.onContextChange(this.context);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreHardLevelsSize(5);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreSoftLevelsSize(10);
    }

    @Test
    public void changeToPlanningEntity() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningEntityValue()).thenReturn((Object)true);
        objectEditor.onPlanningEntityChange();
        DataObject dataObject = this.context.getDataObject();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getPlanningEntityValue();
        Assert.assertNotNull((Object)dataObject.getAnnotation(PlanningEntity.class.getName()));
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initFieldPicker(this.context.getDataModel(), dataObject, null);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreHardLevelsSize(0);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPlanningSolutionBendableScoreSoftLevelsSize(0);
    }

    @Test
    public void changeToPlanningSolution() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.XmlRootElement", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.XmlAccessorType", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put("org.optaplanner.core.api.domain.solution.PlanningScore", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put(Generated.class.getName(), Mockito.mock(AnnotationDefinition.class));
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionValue()).thenReturn((Object)true);
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)HardSoftScore.class.getName());
        objectEditor.onPlanningSolutionChange();
        DataObject dataObject = this.context.getDataObject();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getPlanningSolutionValue();
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(true);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).destroyFieldPicker();
        Assert.assertNotNull((Object)dataObject.getAnnotation(PlanningSolution.class.getName()));
        Assert.assertNotNull((Object)dataObject.getAnnotation(XmlRootElement.class.getName()));
        ObjectProperty scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertEquals((Object)HardSoftScore.class.getName(), (Object)scoreObjectProperty.getClassName());
    }

    @Test
    public void onPlanningSolutionScoreTypeChange() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)BendableScore.class.getName());
        this.context.getAnnotationDefinitions().put("org.optaplanner.core.api.domain.solution.PlanningScore", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.XmlRootElement", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.XmlAccessorType", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put(Generated.class.getName(), Mockito.mock(AnnotationDefinition.class));
        objectEditor.onPlanningSolutionScoreTypeChange();
        DataObject dataObject = this.context.getDataObject();
        ObjectProperty scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertEquals((Object)BendableScore.class.getName(), (Object)scoreObjectProperty.getClassName());
    }

    @Test
    public void onPlanningSolutionBendableScoreHardLevelsSizeChange() {
        this.testPlanningSolutionLevelsSizeChange(true);
    }

    @Test
    public void onPlanningSolutionBendableScoreSoftLevelsSizeChange() {
        this.testPlanningSolutionLevelsSizeChange(false);
    }

    public void testPlanningSolutionLevelsSizeChange(boolean isHardScore) {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(this.context);
        DataObject dataObject = this.context.getDataObject();
        dataObject.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningSolution.class, null, null));
        AnnotationDefinition planningScoreAnnotationDefinition = (AnnotationDefinition)Mockito.mock(AnnotationDefinition.class);
        Mockito.when((Object)planningScoreAnnotationDefinition.getClassName()).thenReturn((Object)PlanningScore.class.getName());
        this.context.getAnnotationDefinitions().put("org.optaplanner.core.api.domain.solution.PlanningScore", planningScoreAnnotationDefinition);
        this.context.getAnnotationDefinitions().put(Generated.class.getName(), Mockito.mock(AnnotationDefinition.class));
        ObjectPropertyImpl scoreObjectProperty = new ObjectPropertyImpl("score", BendableScore.class.getName(), false);
        dataObject.addProperty((ObjectProperty)scoreObjectProperty);
        scoreObjectProperty.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(PlanningScore.class, (Pair[])new Pair[]{new Pair((Object)"bendableHardLevelsSize", (Object)5), new Pair((Object)"bendableSoftLevelsSize", (Object)5)}));
        scoreObjectProperty.addAnnotation(DataModelerEditorsTestHelper.createAnnotation(Generated.class, null, null));
        if (isHardScore) {
            Mockito.when((Object)this.view.getPlanningSolutionBendableScoreHardLevelsSize()).thenReturn((Object)1);
        } else {
            Mockito.when((Object)this.view.getPlanningSolutionBendableScoreSoftLevelsSize()).thenReturn((Object)1);
        }
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)BendableScore.class.getName());
        objectEditor.onPlanningSolutionBendableScoreHardLevelsSizeChange();
        scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Annotation planningScoreAnnotation = scoreObjectProperty.getAnnotation(PlanningScore.class.getName());
        Assert.assertNotNull((Object)planningScoreAnnotation);
        if (isHardScore) {
            Assert.assertEquals((Object)1, (Object)planningScoreAnnotation.getValue("bendableHardLevelsSize"));
        } else {
            Assert.assertEquals((Object)1, (Object)planningScoreAnnotation.getValue("bendableSoftLevelsSize"));
        }
    }

    @Test
    public void updatePlanningScoreProperty() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        AnnotationDefinition planningScoreAnnotationDefinition = (AnnotationDefinition)Mockito.mock(AnnotationDefinition.class);
        Mockito.when((Object)planningScoreAnnotationDefinition.getClassName()).thenReturn((Object)"org.optaplanner.core.api.domain.solution.PlanningScore");
        this.context.getAnnotationDefinitions().put("org.optaplanner.core.api.domain.solution.PlanningScore", planningScoreAnnotationDefinition);
        this.context.getAnnotationDefinitions().put("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter", Mockito.mock(AnnotationDefinition.class));
        this.context.getAnnotationDefinitions().put(Generated.class.getName(), Mockito.mock(AnnotationDefinition.class));
        objectEditor.onContextChange(this.context);
        DataObject dataObject = this.context.getDataObject();
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        objectEditor.updatePlanningScoreProperty(HardSoftScore.class.getName());
        ObjectProperty scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertEquals((Object)HardSoftScore.class.getName(), (Object)scoreObjectProperty.getClassName());
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)HardSoftScore.class.getName());
        objectEditor.onPlanningSolutionScoreTypeChange();
        scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertEquals((Object)HardSoftScore.class.getName(), (Object)scoreObjectProperty.getClassName());
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)BendableScore.class.getName());
        objectEditor.onPlanningSolutionScoreTypeChange();
        scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertNotNull((Object)scoreObjectProperty.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningScore"));
        Assert.assertEquals((Object)BendableScore.class.getName(), (Object)scoreObjectProperty.getClassName());
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(true);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)BendableLongScore.class.getName());
        objectEditor.onPlanningSolutionScoreTypeChange();
        scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertNotNull((Object)scoreObjectProperty.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningScore"));
        Assert.assertEquals((Object)BendableLongScore.class.getName(), (Object)scoreObjectProperty.getClassName());
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(true);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)SimpleScore.class.getName());
        objectEditor.onPlanningSolutionScoreTypeChange();
        scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNotNull((Object)scoreObjectProperty);
        Assert.assertNotNull((Object)scoreObjectProperty.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningScore"));
        Assert.assertEquals((Object)SimpleScore.class.getName(), (Object)scoreObjectProperty.getClassName());
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionBendableScoreInput(false);
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        Mockito.when((Object)this.view.getPlanningSolutionScoreType()).thenReturn((Object)"");
        objectEditor.onPlanningSolutionScoreTypeChange();
        Assert.assertNull((Object)dataObject.getProperty("score"));
        Mockito.when((Object)this.view.getNotInPlanningValue()).thenReturn((Object)true);
        objectEditor.onNotInPlanningChange();
        scoreObjectProperty = dataObject.getProperty("score");
        Assert.assertNull((Object)scoreObjectProperty);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionScoreType(false);
    }

    @Test
    public void getFindClassUsagesCallbackObjectIsAPlanningSolution() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        Path solutionPath = PathFactory.newPath((String)"PlanningSolution.java", (String)"default:///test/PlanningSolution.java");
        HashMap<String, Path> dataObjectPaths = new HashMap<String, Path>();
        dataObjectPaths.put("test.PlanningSolution", solutionPath);
        this.context.getEditorModelContent().setDataObjectPaths(dataObjectPaths);
        DataObjectImpl dataObject = new DataObjectImpl("test", "PlanningSolution");
        this.context.setDataObject((DataObject)dataObject);
        objectEditor.onContextChange(this.context);
        RemoteCallback callback = objectEditor.getFindClassUsagesCallback();
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        callback.callback(Arrays.asList(solutionPath));
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePlanningSolutionCheckBox(true);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionHelpIcon(false);
    }

    @Test
    public void getFindClassUsagesCallbackObjectIsNotAPlanningSolution() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        Path solutionPath = PathFactory.newPath((String)"PlanningSolution.java", (String)"default:///test/PlanningSolution.java");
        Path entityPath = PathFactory.newPath((String)"PlanningEntity.java", (String)"default:///test/PlanningEntity.java");
        HashMap<String, Path> dataObjectPaths = new HashMap<String, Path>();
        dataObjectPaths.put("test.PlanningSolution", solutionPath);
        this.context.getEditorModelContent().setDataObjectPaths(dataObjectPaths);
        DataObjectImpl dataObject = new DataObjectImpl("test", "PlanningEntity");
        this.context.setDataObject((DataObject)dataObject);
        objectEditor.onContextChange(this.context);
        RemoteCallback callback = objectEditor.getFindClassUsagesCallback();
        Mockito.reset((Object[])new PlannerDataObjectEditorView[]{this.view});
        callback.callback(Arrays.asList(solutionPath));
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePlanningSolutionCheckBox(false);
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPlanningSolutionHelpIcon(true);
    }

    @Test
    public void getFindClassUsagesCallbackObjectWithoutContext() {
        PlannerDataObjectEditor objectEditor = this.createObjectEditor();
        objectEditor.onContextChange(null);
        objectEditor.getFindClassUsagesCallback().callback(Collections.emptyList());
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enablePlanningSolutionCheckBox(Mockito.anyBoolean());
        ((PlannerDataObjectEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showPlanningSolutionHelpIcon(Mockito.anyBoolean());
    }
}

