/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPicker;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItem;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemView;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataObjectFieldPickerItemTest {
    @Mock
    private DataObjectFieldPickerItemView view;
    @Mock
    private DataModel dataModel;
    @Mock
    private DataObject dataObject;
    @Mock
    private DataObjectFieldPicker fieldPicker;
    private DataObjectFieldPickerItem fieldPickerItem;

    @Before
    public void setUp() {
        this.fieldPickerItem = new DataObjectFieldPickerItem(this.view);
    }

    @Test
    public void setPresenter() {
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setPresenter((DataObjectFieldPickerItemView.Presenter)this.fieldPickerItem);
    }

    @Test
    public void init() {
        this.fieldPickerItem.init(this.dataModel, this.dataObject, this.fieldPicker);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initSelectFieldDropdownOptions(Matchers.anyList());
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addRootItem((DataObject)Matchers.any(DataObject.class));
    }

    @Test
    public void onFieldAddedObjectType() {
        this.fieldPickerItem.init(this.dataModel, this.dataObject, this.fieldPicker);
        ObjectProperty objectProperty = (ObjectProperty)Mockito.mock(ObjectProperty.class);
        Mockito.when((Object)objectProperty.getName()).thenReturn((Object)"testProperty");
        Mockito.when((Object)objectProperty.getClassName()).thenReturn((Object)"bar.foo.TestProperty");
        Mockito.when((Object)objectProperty.isBaseType()).thenReturn((Object)false);
        Mockito.when((Object)objectProperty.isPrimitiveType()).thenReturn((Object)false);
        DataObject nestedDataObject = (DataObject)Mockito.mock(DataObject.class);
        Mockito.when((Object)nestedDataObject.getProperties()).thenReturn(Arrays.asList((ObjectProperty)Mockito.mock(ObjectProperty.class)));
        Mockito.when((Object)this.dataObject.getProperty("testProperty")).thenReturn((Object)objectProperty);
        Mockito.when((Object)this.dataModel.getDataObject("bar.foo.TestProperty")).thenReturn((Object)nestedDataObject);
        Mockito.reset((Object[])new DataObjectFieldPickerItemView[]{this.view});
        this.fieldPickerItem.onFieldAdded(objectProperty, true);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addFieldItem(objectProperty);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initSelectFieldDropdownOptions(Matchers.anyList());
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displaySelectFieldButton(true);
        ((DataObjectFieldPicker)Mockito.verify((Object)this.fieldPicker, (VerificationMode)Mockito.times((int)1))).objectPropertyPathChanged(false);
    }

    @Test
    public void onFieldAddedPrimitive() {
        this.fieldPickerItem.init(this.dataModel, this.dataObject, this.fieldPicker);
        ObjectProperty objectProperty = (ObjectProperty)Mockito.mock(ObjectProperty.class);
        Mockito.when((Object)objectProperty.getName()).thenReturn((Object)"testProperty");
        Mockito.when((Object)objectProperty.getClassName()).thenReturn((Object)"java.lang.Integer");
        Mockito.when((Object)objectProperty.isBaseType()).thenReturn((Object)true);
        Mockito.when((Object)objectProperty.isPrimitiveType()).thenReturn((Object)false);
        Mockito.when((Object)this.dataObject.getProperty("testProperty")).thenReturn((Object)objectProperty);
        Mockito.reset((Object[])new DataObjectFieldPickerItemView[]{this.view});
        this.fieldPickerItem.onFieldAdded(objectProperty, true);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addFieldItem(objectProperty);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initSelectFieldDropdownOptions(Matchers.anyList());
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displaySelectFieldButton(false);
        ((DataObjectFieldPicker)Mockito.verify((Object)this.fieldPicker, (VerificationMode)Mockito.times((int)1))).objectPropertyPathChanged(false);
    }

    @Test
    public void onFieldRemoved() {
        this.fieldPickerItem.init(this.dataModel, this.dataObject, this.fieldPicker);
        ObjectProperty objectProperty = (ObjectProperty)Mockito.mock(ObjectProperty.class);
        Mockito.when((Object)objectProperty.getName()).thenReturn((Object)"testProperty");
        Mockito.when((Object)objectProperty.getClassName()).thenReturn((Object)"java.lang.Integer");
        Mockito.when((Object)objectProperty.isBaseType()).thenReturn((Object)true);
        Mockito.when((Object)objectProperty.isPrimitiveType()).thenReturn((Object)false);
        Mockito.when((Object)this.dataObject.getProperty("testProperty")).thenReturn((Object)objectProperty);
        this.fieldPickerItem.onFieldAdded(objectProperty, true);
        Mockito.reset((Object[])new IsWidget[]{this.view, this.fieldPicker});
        this.fieldPickerItem.onFieldRemoved(objectProperty);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).removeLastFieldItem();
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).displaySelectFieldButton(true);
        ((DataObjectFieldPickerItemView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initSelectFieldDropdownOptions(Matchers.anyList());
        ((DataObjectFieldPicker)Mockito.verify((Object)this.fieldPicker, (VerificationMode)Mockito.times((int)1))).objectPropertyPathChanged(true);
    }
}

