/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.editor;

import com.google.gwt.resources.client.ImageResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datamodeller.model.editor.FieldMetadata;
import org.kie.workbench.common.screens.datamodeller.model.editor.FieldMetadataProvider;
import org.kie.workbench.common.screens.datamodeller.model.editor.ImageWrapper;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.resources.images.DomainImageResources;

@ApplicationScoped
public class PlannerFieldMetadataProvider
implements FieldMetadataProvider {
    private Map<String, String> PLANNER_ANNOTATION_DESCRIPTION_MAP = new HashMap<String, String>(3);
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.PLANNER_ANNOTATION_DESCRIPTION_MAP.put("org.optaplanner.core.api.domain.solution.PlanningScore", this.translationService.getTranslation("PlannerFieldMetadataProvider.PlanningScore"));
        this.PLANNER_ANNOTATION_DESCRIPTION_MAP.put("org.optaplanner.core.api.domain.variable.PlanningVariable", this.translationService.getTranslation("PlannerFieldMetadataProvider.PlanningVariable"));
        this.PLANNER_ANNOTATION_DESCRIPTION_MAP.put("org.optaplanner.core.api.domain.valuerange.ValueRangeProvider", this.translationService.getTranslation("PlannerFieldMetadataProvider.ValueRangeProvider"));
    }

    @Inject
    public PlannerFieldMetadataProvider(TranslationService translationService) {
        this.translationService = translationService;
    }

    public Optional<FieldMetadata> getFieldMetadata(ObjectProperty objectProperty) {
        if (objectProperty.getAnnotations() != null) {
            return objectProperty.getAnnotations().stream().map(p -> this.PLANNER_ANNOTATION_DESCRIPTION_MAP.get(p.getClassName())).filter(Objects::nonNull).findFirst().map(description -> {
                ImageResource imageResource = DomainImageResources.INSTANCE.optaPlannerDomainEditorFieldIcon();
                ImageWrapper imageWrapper = new ImageWrapper(imageResource.getSafeUri().asString(), description);
                return new FieldMetadata(imageWrapper);
            });
        }
        return Optional.empty();
    }
}

