/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.handlers.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Generated;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ParameterImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.TypeImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.workbench.screens.domaineditor.client.handlers.planner.ComparatorDefinitionAnnotationValueHandler;
import org.optaplanner.workbench.screens.domaineditor.client.handlers.planner.PlannerDomainHandler;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.PlannerTestUtil;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.model.ObjectPropertyPathImpl;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;

@RunWith(value=MockitoJUnitRunner.class)
public class PlannerDomainHandlerTest {
    @Mock
    private Caller<ComparatorDefinitionService> comparatorDefinitionService;
    private DataObject dataObject;
    private JavaClassImpl comparatorObject;
    private PlannerDomainHandler plannerDomainHandler;

    @Before
    public void setUp() {
        Mockito.when((Object)((ComparatorDefinitionService)this.comparatorDefinitionService.call((RemoteCallback)Mockito.any()))).thenReturn((Object)((ComparatorDefinitionService)Mockito.mock(ComparatorDefinitionService.class)));
        this.plannerDomainHandler = new PlannerDomainHandler(this.comparatorDefinitionService);
        this.initDataObjects();
    }

    @Test
    public void postEventProcessingDataObjectFieldDeleted() {
        DataObjectFieldDeletedEvent event = (DataObjectFieldDeletedEvent)new DataObjectFieldDeletedEvent().withCurrentDataObject(this.dataObject).withCurrentField(this.dataObject.getProperty("dataObject1Property2"));
        Annotation comparatorDefinitionAnnotation = this.comparatorObject.getAnnotation(ComparatorDefinition.class.getName());
        ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinitionAnnotation);
        Assert.assertFalse((boolean)comparatorAnnotationHandler.getObjectPropertyPaths().isEmpty());
        this.plannerDomainHandler.onDataObjectFieldDeletedEvent(event);
        Assert.assertTrue((boolean)comparatorAnnotationHandler.getObjectPropertyPaths().isEmpty());
    }

    @Test
    public void postEventProcessingDataObjectNameChanged() {
        DataObjectChangeEvent event = new DataObjectChangeEvent(ChangeType.OBJECT_NAME_CHANGE, "testContextId", "testSource", this.dataObject, null, (Object)this.dataObject.getName(), (Object)"DataObject1NewName");
        Annotation planningEntityAnnotation = this.dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
        Assert.assertNotNull((Object)planningEntityAnnotation);
        Object difficultyComparatorClass = planningEntityAnnotation.getValue("difficultyComparatorClass");
        Assert.assertEquals((Object)(this.dataObject.getName() + ".DifficultyComparator.class"), (Object)difficultyComparatorClass);
        this.dataObject.setName("DataObject1NewName");
        this.plannerDomainHandler.onDataModelerValueChangeEvent((DataModelerValueChangeEvent)event);
        planningEntityAnnotation = this.dataObject.getAnnotation("org.optaplanner.core.api.domain.entity.PlanningEntity");
        Assert.assertNotNull((Object)planningEntityAnnotation);
        difficultyComparatorClass = planningEntityAnnotation.getValue("difficultyComparatorClass");
        Assert.assertEquals((Object)"DataObject1NewName.DifficultyComparator.class", (Object)difficultyComparatorClass);
    }

    @Test
    public void postEventProcessingFieldNameChanged() {
        ObjectProperty objectProperty = this.dataObject.getProperty("dataObject1Property2");
        DataObjectFieldChangeEvent event = new DataObjectFieldChangeEvent(ChangeType.FIELD_NAME_CHANGE, "testContextId", "testSource", this.dataObject, objectProperty, null, (Object)"dataObject1Property2", (Object)"dataObject1Property2NewName");
        Annotation comparatorDefinitionAnnotation = this.comparatorObject.getAnnotation(ComparatorDefinition.class.getName());
        ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinitionAnnotation);
        Assert.assertEquals((long)1L, (long)comparatorAnnotationHandler.getObjectPropertyPaths().size());
        Annotation objectPropertyPath = (Annotation)comparatorAnnotationHandler.getObjectPropertyPaths().get(0);
        Assert.assertEquals((long)2L, (long)comparatorAnnotationHandler.getObjectProperties(objectPropertyPath).size());
        Annotation comparatorObjectProperty = (Annotation)comparatorAnnotationHandler.getObjectProperties(objectPropertyPath).get(0);
        Assert.assertEquals((Object)"dataObject1Property2", (Object)comparatorAnnotationHandler.getName(comparatorObjectProperty));
        objectProperty.setName("dataObject1Property2NewName");
        this.plannerDomainHandler.onDataModelerValueChangeEvent((DataModelerValueChangeEvent)event);
        Assert.assertEquals((Object)"dataObject1Property2NewName", (Object)comparatorAnnotationHandler.getName(comparatorObjectProperty));
        Assert.assertEquals((long)1L, (long)comparatorAnnotationHandler.getObjectPropertyPaths().size());
        Assert.assertEquals((long)2L, (long)comparatorAnnotationHandler.getObjectProperties(objectPropertyPath).size());
    }

    @Test
    public void postEventProcessingFieldTypeChanged() {
        ObjectProperty objectProperty = this.dataObject.getProperty("dataObject1Property2");
        String oldType = objectProperty.getClassName();
        DataObjectFieldChangeEvent event = new DataObjectFieldChangeEvent(ChangeType.FIELD_TYPE_CHANGE, "testContextId", "testSource", this.dataObject, objectProperty, null, (Object)oldType, (Object)(oldType + "NewType"));
        Annotation comparatorDefinitionAnnotation = this.comparatorObject.getAnnotation(ComparatorDefinition.class.getName());
        ComparatorDefinitionAnnotationValueHandler comparatorAnnotationHandler = new ComparatorDefinitionAnnotationValueHandler(comparatorDefinitionAnnotation);
        Assert.assertEquals((long)1L, (long)comparatorAnnotationHandler.getObjectPropertyPaths().size());
        Annotation objectPropertyPath = (Annotation)comparatorAnnotationHandler.getObjectPropertyPaths().get(0);
        Assert.assertEquals((long)2L, (long)comparatorAnnotationHandler.getObjectProperties(objectPropertyPath).size());
        Annotation comparatorObjectProperty = (Annotation)comparatorAnnotationHandler.getObjectProperties(objectPropertyPath).get(0);
        Assert.assertEquals((Object)oldType, (Object)comparatorAnnotationHandler.getType(comparatorObjectProperty));
        objectProperty.setClassName(oldType + "NewType");
        this.plannerDomainHandler.onDataModelerValueChangeEvent((DataModelerValueChangeEvent)event);
        Assert.assertEquals((Object)(oldType + "NewType"), (Object)comparatorAnnotationHandler.getType(comparatorObjectProperty));
        Assert.assertEquals((long)1L, (long)comparatorAnnotationHandler.getObjectPropertyPaths().size());
        Assert.assertEquals((long)1L, (long)comparatorAnnotationHandler.getObjectProperties(objectPropertyPath).size());
    }

    private void initDataObjects() {
        Map<String, AnnotationDefinition> annotationDefinitionMap = PlannerTestUtil.getComparatorObjectAnnotations();
        DataObjectImpl dataObject1 = new DataObjectImpl("bar.foo", "DataObject1");
        ObjectPropertyImpl dataObject1Property1 = new ObjectPropertyImpl("dataObject1Property1", "java.lang.Integer", false);
        ObjectPropertyImpl dataObject1Property2 = new ObjectPropertyImpl("dataObject1Property2", "bar.foo.DataObject2", false);
        dataObject1.addProperty((ObjectProperty)dataObject1Property1);
        dataObject1.addProperty((ObjectProperty)dataObject1Property2);
        JavaClassImpl comparatorObject = new JavaClassImpl("", "DifficultyComparator");
        comparatorObject.addInterface(Comparator.class.getName());
        comparatorObject.addAnnotation((Annotation)new AnnotationImpl(annotationDefinitionMap.get(Generated.class.getName())));
        MethodImpl compareMethod = new MethodImpl("compare", Arrays.asList(new ParameterImpl((Type)new TypeImpl(dataObject1.getClassName()), "o1"), new ParameterImpl((Type)new TypeImpl(dataObject1.getClassName()), "o2")), "foo", (Type)new TypeImpl("int"), Visibility.PUBLIC);
        comparatorObject.addMethod((Method)compareMethod);
        dataObject1.addNestedClass((JavaClass)comparatorObject);
        AnnotationImpl planningEntityAnnotation = new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningEntity.class));
        planningEntityAnnotation.setValue("difficultyComparatorClass", (Object)(dataObject1.getName() + ".DifficultyComparator.class"));
        dataObject1.addAnnotation((Annotation)planningEntityAnnotation);
        ObjectPropertyPathImpl objectPropertyPath = new ObjectPropertyPathImpl();
        objectPropertyPath.appendObjectProperty((ObjectProperty)dataObject1Property2);
        objectPropertyPath.appendObjectProperty((ObjectProperty)dataObject1Property1);
        ArrayList<ObjectPropertyPathImpl> objectPropertyPathList = new ArrayList<ObjectPropertyPathImpl>(1);
        objectPropertyPathList.add(objectPropertyPath);
        Annotation comparatorDefinitionAnnotation = ComparatorDefinitionAnnotationValueHandler.createAnnotation(objectPropertyPathList, annotationDefinitionMap);
        comparatorObject.addAnnotation(comparatorDefinitionAnnotation);
        DataObjectImpl dataObject2 = new DataObjectImpl("bar.foo", "DataObject2");
        ObjectPropertyImpl dataObject2Property1 = new ObjectPropertyImpl("dataObject2Property1", "java.lang.Double", false);
        dataObject2.addProperty((ObjectProperty)dataObject2Property1);
        this.dataObject = dataObject1;
        this.comparatorObject = comparatorObject;
    }
}

