/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListGroup;
import org.gwtbootstrap3.client.ui.ListGroupItem;
import org.jboss.errai.common.client.dom.CheckboxInput;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItem;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerView;

@Templated
public class DataObjectFieldPickerViewImpl
extends Composite
implements DataObjectFieldPickerView {
    @Inject
    @DataField(value="view")
    Div view;
    @DataField(value="comparatorCheckbox")
    CheckboxInput comparatorCheckbox;
    @DataField(value="fieldDiv")
    Div fieldDiv;
    @Inject
    @DataField(value="fieldList")
    ListGroup fieldList;
    @Inject
    @DataField(value="addFieldPickerItemButton")
    Button addFieldPickerItemButton;
    private DataObjectFieldPickerView.Presenter presenter;

    public DataObjectFieldPickerViewImpl() {
    }

    @Inject
    public DataObjectFieldPickerViewImpl(CheckboxInput comparatorCheckbox, Div fieldDiv) {
        this.comparatorCheckbox = comparatorCheckbox;
        this.fieldDiv = fieldDiv;
        comparatorCheckbox.setHidden(false);
        fieldDiv.setHidden(true);
    }

    @Override
    public void setPresenter(DataObjectFieldPickerView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addFieldPickerItem(DataObjectFieldPickerItem fieldPickerItem) {
        ListGroupItem listGroupItem = new ListGroupItem();
        listGroupItem.add((IsWidget)fieldPickerItem);
        this.fieldList.add((Widget)listGroupItem);
    }

    @Override
    public void removeFieldPickerItem(int position) {
        this.fieldList.remove(position);
    }

    @Override
    public void displayFieldPicker(boolean display) {
        this.fieldDiv.setHidden(!display);
    }

    @Override
    public void displayComparatorCheckbox(boolean display) {
        this.view.setHidden(!display);
    }

    @Override
    public void setComparatorCheckboxValue(boolean checked) {
        this.comparatorCheckbox.setChecked(checked);
    }

    @Override
    public void clear() {
        this.fieldList.clear();
        this.comparatorCheckbox.setChecked(false);
    }

    @Override
    public void moveFieldItemUp(int currentPosition) {
        if (currentPosition == 0) {
            return;
        }
        Widget widget = this.fieldList.getWidget(currentPosition);
        this.fieldList.remove(widget);
        this.fieldList.insert(widget, currentPosition - 1);
    }

    @Override
    public void moveFieldItemDown(int currentPosition) {
        if (currentPosition == this.fieldList.getWidgetCount() - 1) {
            return;
        }
        Widget widget = this.fieldList.getWidget(currentPosition);
        this.fieldList.remove(widget);
        this.fieldList.insert(widget, currentPosition + 1);
    }

    @EventHandler(value={"addFieldPickerItemButton"})
    public void onAddFieldPickerItemButtonClicked(ClickEvent event) {
        this.presenter.addFieldPickerItem();
    }

    @EventHandler(value={"comparatorCheckbox"})
    public void onComparatorCheckboxClicked(ChangeEvent event) {
        this.presenter.onComparatorSpecified(this.comparatorCheckbox.getChecked());
    }
}

