/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.widgets.planner;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemLabelView;
import org.optaplanner.workbench.screens.domaineditor.client.widgets.planner.DataObjectFieldPickerItemView;
import org.uberfire.mvp.Command;

@Templated
public class DataObjectFieldPickerItemViewImpl
extends Composite
implements DataObjectFieldPickerItemView {
    @Inject
    @DataField(value="view")
    Div view;
    @Inject
    @DataField(value="fieldPickerItemRow")
    Div fieldPickerItemRow;
    @Inject
    @DataField(value="selectFieldButton")
    org.jboss.errai.common.client.dom.Button selectFieldButton;
    @Inject
    @DataField(value="selectFieldDropdown")
    DropDownMenu selectFieldDropdown;
    @Inject
    @DataField(value="moveUpButton")
    Button moveUpButton;
    @Inject
    @DataField(value="moveDownButton")
    Button moveDownButton;
    @Inject
    @DataField(value="ascSortButton")
    Button ascSortButton;
    @Inject
    @DataField(value="descSortButton")
    Button descSortButton;
    @Inject
    @DataField(value="sortIndexLabel")
    Label sortIndexLabel;
    private ManagedInstance<DataObjectFieldPickerItemLabelView> fieldPickerItemLabelViewInstance;
    private DataObjectFieldPickerItemView.Presenter presenter;

    @Inject
    public DataObjectFieldPickerItemViewImpl(Div fieldPickerItemRow, ManagedInstance<DataObjectFieldPickerItemLabelView> fieldPickerItemLabelViewInstance) {
        this.fieldPickerItemRow = fieldPickerItemRow;
        this.fieldPickerItemLabelViewInstance = fieldPickerItemLabelViewInstance;
    }

    @PostConstruct
    public void init() {
        this.moveUpButton.setIcon(IconType.ARROW_UP);
        this.moveDownButton.setIcon(IconType.ARROW_DOWN);
        this.ascSortButton.setIcon(IconType.SORT_ALPHA_ASC);
        this.descSortButton.setIcon(IconType.SORT_ALPHA_DESC);
    }

    @Override
    public void setPresenter(DataObjectFieldPickerItemView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initSelectFieldDropdownOptions(List<ObjectProperty> options) {
        this.selectFieldDropdown.clear();
        for (ObjectProperty option : options) {
            AnchorListItem listItem = new AnchorListItem(option.getName());
            listItem.addClickHandler(c -> this.presenter.onFieldAdded(option, true));
            this.selectFieldDropdown.add((Widget)listItem);
        }
    }

    @Override
    public void addRootItem(DataObject rootDataObject) {
        this.createFieldPickerItemLabel(rootDataObject.getName(), () -> this.presenter.onRootLabelRemoved());
    }

    @Override
    public void addFieldItem(ObjectProperty objectProperty) {
        this.createFieldPickerItemLabel(objectProperty.getName(), () -> this.presenter.onFieldRemoved(objectProperty));
    }

    private void createFieldPickerItemLabel(String name, Command removeLabelCommand) {
        DataObjectFieldPickerItemLabelView labelView = (DataObjectFieldPickerItemLabelView)this.fieldPickerItemLabelViewInstance.get();
        labelView.setName(name);
        labelView.setRemoveLabelCommand(removeLabelCommand);
        this.fieldPickerItemRow.appendChild((Node)labelView.getElement());
    }

    @Override
    public void removeLastFieldItem() {
        this.fieldPickerItemRow.removeChild(this.fieldPickerItemRow.getLastChild());
    }

    @Override
    public void displaySelectFieldButton(boolean display) {
        this.selectFieldButton.setDisabled(!display);
    }

    @Override
    public void setOrderSelectDescendingValue(boolean descending) {
        this.ascSortButton.setVisible(!descending);
        this.descSortButton.setVisible(descending);
    }

    @Override
    public void setFieldPickerItemIndex(int index) {
        this.sortIndexLabel.setTextContent(index + ".");
    }

    @EventHandler(value={"moveUpButton"})
    public void onMoveUpButtonClicked(ClickEvent event) {
        this.presenter.onMoveFieldItemUp();
    }

    @EventHandler(value={"moveDownButton"})
    public void onMoveDownButtonClicked(ClickEvent event) {
        this.presenter.onMoveFieldItemDown();
    }

    @EventHandler(value={"ascSortButton"})
    public void onAscSortButtonClicked(ClickEvent event) {
        this.presenter.onOrderSelectValueChange(true, true);
    }

    @EventHandler(value={"descSortButton"})
    public void onDescSortButtonClicked(ClickEvent event) {
        this.presenter.onOrderSelectValueChange(false, true);
    }
}

