/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.client.validation;

import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.workbench.screens.domaineditor.client.validation.PlannerValidationMessageTranslator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;

@RunWith(value=MockitoJUnitRunner.class)
public class PlannerValidationMessageTranslatorTest {
    @Mock
    private TranslationService translationService;
    private PlannerValidationMessageTranslator translator;

    @Before
    public void setUp() {
        this.translator = new PlannerValidationMessageTranslator(this.translationService);
    }

    @Test
    public void acceptSupportedClass() {
        Assert.assertTrue((boolean)this.translator.accept((ValidationMessage)new PlanningSolutionToBeDuplicatedMessage(Level.ERROR)));
    }

    @Test
    public void acceptUnsupportedClass() {
        Assert.assertFalse((boolean)this.translator.accept((ValidationMessage)new UnsupportedMessage()));
    }

    @Test
    public void translateSupported() {
        Mockito.when((Object)this.translationService.getTranslation(Matchers.anyString())).thenReturn((Object)"Test translation");
        ValidationMessage translatedMessage = this.translator.translate((ValidationMessage)new PlanningSolutionToBeDuplicatedMessage(Level.ERROR));
        Assert.assertEquals((Object)"Test translation", (Object)translatedMessage.getText());
    }

    @Test(expected=IllegalStateException.class)
    public void translateUnsupported() {
        Assert.assertNotNull((Object)this.translator.translate((ValidationMessage)new UnsupportedMessage()));
    }

    private class UnsupportedMessage
    extends ValidationMessage {
        private UnsupportedMessage() {
        }
    }
}

