/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.util;

import java.util.Collection;
import java.util.function.Function;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.screens.guidedrule.util.TemplateUtils;

public class TemplateUtilsTest {
    @Test
    public void extractInterpolationVariablesContainsVariables() {
        String string = "foo bar @{var1} baz @{var2}";
        Collection interpolationVariables = TemplateUtils.extractInterpolationVariables((String)string);
        Assert.assertEquals((long)2L, (long)interpolationVariables.size());
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var1", "Object")));
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var2", "Object")));
    }

    @Test
    public void extractInterpolationVariablesBrokenPattern() {
        String string = "foo @{zzz bar baz @";
        Collection interpolationVariables = TemplateUtils.extractInterpolationVariables((String)string);
        Assert.assertTrue((boolean)interpolationVariables.isEmpty());
    }

    @Test
    public void extractInterpolationVariablesNoVariables() {
        String string = "foo bar baz";
        Collection interpolationVariables = TemplateUtils.extractInterpolationVariables((String)string);
        Assert.assertTrue((boolean)interpolationVariables.isEmpty());
    }

    @Test
    public void substituteTemplateKey() {
        String string = "foo bar @{var1} baz @{var2}";
        Function<String, String> keyToValueFunction = s -> {
            switch (s) {
                case "var1": {
                    return "val1";
                }
                case "var2": {
                    return "val2";
                }
            }
            throw new IllegalArgumentException("Undefined variable " + s);
        };
        String result = TemplateUtils.substituteTemplateVariable((String)string, keyToValueFunction);
        Assert.assertEquals((Object)"foo bar val1 baz val2", (Object)result);
    }
}

