/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.datamodel.rule.IAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.SimpleConstraintMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.UnknownIAction;
import org.optaplanner.workbench.screens.guidedrule.model.ActionSimpleConstraintMatch;

public class SimpleConstraintMatchPersistenceExtensionTest {
    private SimpleConstraintMatchPersistenceExtension extension = new SimpleConstraintMatchPersistenceExtension();

    @Test
    public void acceptIAction() {
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionSimpleConstraintMatch()));
        Assert.assertFalse((boolean)this.extension.accept((IAction)new UnknownIAction()));
    }

    @Test
    public void marshalActionSimpleConstraintMatch() {
        ActionSimpleConstraintMatch action = new ActionSimpleConstraintMatch("-1");
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addConstraintMatch(kcontext, -1);", (Object)marshaledAction);
    }

    @Test(expected=IllegalArgumentException.class)
    public void marshalUnknownIAction() {
        this.extension.marshal((IAction)new UnknownIAction());
    }

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addConstraintMatch(kcontext, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalSimpleConstraintMatch() {
        String actionString = "scoreHolder.addConstraintMatch(kcontext, -1);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSimpleConstraintMatch));
        ActionSimpleConstraintMatch actionSimpleConstraintMatch = (ActionSimpleConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionSimpleConstraintMatch.getConstraintMatch());
    }
}

