/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMediumConstraintMatch;

@ApplicationScoped
public class MediumConstraintMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addMediumConstraintMatch\\(\\s*kcontext\\s*,.+\\);");

    public boolean accept(IAction iAction) {
        return iAction instanceof ActionMediumConstraintMatch;
    }

    public String marshal(IAction iAction) {
        if (iAction instanceof ActionMediumConstraintMatch) {
            ActionMediumConstraintMatch actionConstraintMatch = (ActionMediumConstraintMatch)iAction;
            return String.format("scoreHolder.addMediumConstraintMatch(kcontext, %s);", actionConstraintMatch.getConstraintMatch());
        }
        throw new IllegalArgumentException("Action " + iAction + " is not supported by this extension");
    }

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public IAction unmarshal(String iActionString) {
        String[] parameters = PersistenceExtensionUtils.unwrapParenthesis(iActionString).split("\\s*,\\s*");
        if ("kcontext".equals(parameters[0]) && parameters.length == 2) {
            return new ActionMediumConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue(parameters[1]));
        }
        FreeFormLine freeFormLine = new FreeFormLine();
        freeFormLine.setText(iActionString);
        return freeFormLine;
    }
}

