/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionMediumConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.MediumConstraintMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.TestUtils;

public class MediumConstraintMatchPersistenceExtensionTest {
    private MediumConstraintMatchPersistenceExtension extension = new MediumConstraintMatchPersistenceExtension();
    private TestUtils testUtils = new TestUtils((RuleModelIActionPersistenceExtension)this.extension);

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMediumConstraintMatch(kcontext, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalMediumConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMediumConstraintMatch(kcontext, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMediumConstraintMatch));
        ActionMediumConstraintMatch actionMediumConstraintMatch = (ActionMediumConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionMediumConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalMediumConstraintMatchNull() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMediumConstraintMatch(kcontext, null);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMediumConstraintMatch));
        ActionMediumConstraintMatch actionMediumConstraintMatch = (ActionMediumConstraintMatch)action;
        Assert.assertNull((Object)actionMediumConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        String actionText = "unrecognizedString";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("unrecognizedString");
    }

    @Test
    public void unmarshalTooManyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMediumConstraintMatch(kcontext, -1, 123);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMediumConstraintMatch(kcontext, -1, 123);");
    }

    @Test
    public void unmarshalArgumentsInvalid() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMediumConstraintMatch(context, 123, 321);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMediumConstraintMatch(context, 123, 321);");
    }

    @Test
    public void unmarshalNotEnoughArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMediumConstraintMatch(kcontext);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMediumConstraintMatch(kcontext);");
    }

    @Test
    public void unmarshalWrongFirstArgument() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMediumConstraintMatch(context, 1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMediumConstraintMatch(context, 1);");
    }

    @Test
    public void unmarshalEmptyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addMediumConstraintMatch( , );";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addMediumConstraintMatch( , );");
    }
}

