/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.SoftConstraintMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.TestUtils;

public class SoftConstraintMatchPersistenceExtensionTest {
    private SoftConstraintMatchPersistenceExtension extension = new SoftConstraintMatchPersistenceExtension();
    private TestUtils testUtils = new TestUtils((RuleModelIActionPersistenceExtension)this.extension);

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addSoftConstraintMatch(kcontext, -1);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalSoftConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSoftConstraintMatch));
        ActionSoftConstraintMatch actionSoftConstraintMatch = (ActionSoftConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionSoftConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalSoftConstraintMatchNull() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, null);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSoftConstraintMatch));
        ActionSoftConstraintMatch actionSoftConstraintMatch = (ActionSoftConstraintMatch)action;
        Assert.assertNull((Object)actionSoftConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalActionBendableSoftConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionBendableSoftConstraintMatch));
        ActionBendableSoftConstraintMatch actionSoftConstraintMatch = (ActionBendableSoftConstraintMatch)action;
        Assert.assertEquals((long)1L, (long)actionSoftConstraintMatch.getPosition());
        Assert.assertEquals((Object)"-1", (Object)actionSoftConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        String actionText = "unrecognizedString";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("unrecognizedString");
    }

    @Test
    public void unmarshalTooManyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addSoftConstraintMatch(kcontext, 1, -1, 123);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addSoftConstraintMatch(kcontext, 1, -1, 123);");
    }

    @Test
    public void unmarshalNotEnoughArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addSoftConstraintMatch(kcontext);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addSoftConstraintMatch(kcontext);");
    }

    @Test
    public void unmarshalEmptyArguments() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addSoftConstraintMatch();";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addSoftConstraintMatch();");
    }

    @Test
    public void unmarshalWrongFirstArgument() throws RuleModelDRLPersistenceException {
        String actionText = "scoreHolder.addSoftConstraintMatch(context, 1, -1);";
        this.testUtils.assertRuleModelDRLPersistenceExceptionWasThrown("scoreHolder.addSoftConstraintMatch(context, 1, -1);");
    }
}

