/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.datamodel.rule.IAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.HardConstraintMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.UnknownIAction;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionHardConstraintMatch;

public class HardConstraintMatchPersistenceExtensionTest {
    private HardConstraintMatchPersistenceExtension extension = new HardConstraintMatchPersistenceExtension();

    @Test
    public void acceptIAction() {
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionHardConstraintMatch()));
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionBendableHardConstraintMatch()));
        Assert.assertFalse((boolean)this.extension.accept((IAction)new UnknownIAction()));
    }

    @Test
    public void marshalActionHardConstraintMatch() {
        ActionHardConstraintMatch action = new ActionHardConstraintMatch("-1");
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addHardConstraintMatch(kcontext, -1);", (Object)marshaledAction);
    }

    @Test
    public void marshalActionBendableHardConstraintMatch() {
        ActionBendableHardConstraintMatch action = new ActionBendableHardConstraintMatch(1, "-1");
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addHardConstraintMatch(kcontext, 1, -1);", (Object)marshaledAction);
    }

    @Test(expected=IllegalArgumentException.class)
    public void marshalUnknownIAction() {
        this.extension.marshal((IAction)new UnknownIAction());
    }

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addHardConstraintMatch(kcontext, -1);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addHardConstraintMatch(kcontext, 1, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalHardConstraintMatch() {
        String actionString = "scoreHolder.addHardConstraintMatch(kcontext, -1);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionHardConstraintMatch));
        ActionHardConstraintMatch actionHardConstraintMatch = (ActionHardConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionHardConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalActionBendableHardConstraintMatch() {
        String actionString = "scoreHolder.addHardConstraintMatch(kcontext, 1, -1);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionBendableHardConstraintMatch));
        ActionBendableHardConstraintMatch actionHardConstraintMatch = (ActionBendableHardConstraintMatch)action;
        Assert.assertEquals((long)1L, (long)actionHardConstraintMatch.getPosition());
        Assert.assertEquals((Object)"-1", (Object)actionHardConstraintMatch.getConstraintMatch());
    }
}

