/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.List;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionHardConstraintMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HardConstraintMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardConstraintMatchPersistenceExtension.class);
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addHardConstraintMatch\\(\\s*kcontext\\s*,.+\\);");

    public boolean accept(IAction iAction) {
        return iAction instanceof ActionHardConstraintMatch || iAction instanceof ActionBendableHardConstraintMatch;
    }

    public String marshal(IAction iAction) {
        if (iAction instanceof ActionHardConstraintMatch) {
            ActionHardConstraintMatch actionConstraintMatch = (ActionHardConstraintMatch)iAction;
            return String.format("scoreHolder.addHardConstraintMatch(kcontext, %s);", actionConstraintMatch.getConstraintMatch());
        }
        if (iAction instanceof ActionBendableHardConstraintMatch) {
            ActionBendableHardConstraintMatch actionConstraintMatch = (ActionBendableHardConstraintMatch)iAction;
            return String.format("scoreHolder.addHardConstraintMatch(kcontext, %s, %s);", actionConstraintMatch.getPosition(), actionConstraintMatch.getConstraintMatch());
        }
        throw new IllegalArgumentException("Action " + iAction + " is not supported by this extension");
    }

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public IAction unmarshal(String iActionString) {
        List parameters = StringUtils.splitArgumentsList((CharSequence)PersistenceExtensionUtils.unwrapParenthesis(iActionString));
        if (!parameters.isEmpty() && "kcontext".equals(parameters.get(0))) {
            if (parameters.size() == 2) {
                return new ActionHardConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(1)));
            }
            if (parameters.size() == 3) {
                try {
                    int bendableScoreLevel = Integer.parseInt((String)parameters.get(1));
                    return new ActionBendableHardConstraintMatch(bendableScoreLevel, PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(2)));
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse bendable score level parameter " + (String)parameters.get(1) + " as an Integer, returning a FreeFormLine");
                }
            }
        }
        FreeFormLine freeFormLine = new FreeFormLine();
        freeFormLine.setText(iActionString);
        return freeFormLine;
    }
}

