/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.HardConstraintMatchPersistenceExtension;

public class HardConstraintMatchPersistenceExtensionTest {
    private HardConstraintMatchPersistenceExtension extension = new HardConstraintMatchPersistenceExtension();

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addHardConstraintMatch(kcontext, -1);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addHardConstraintMatch(kcontext, 1, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalHardConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addHardConstraintMatch(kcontext, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionHardConstraintMatch));
        ActionHardConstraintMatch actionHardConstraintMatch = (ActionHardConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionHardConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalActionBendableHardConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addHardConstraintMatch(kcontext, 1, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionBendableHardConstraintMatch));
        ActionBendableHardConstraintMatch actionHardConstraintMatch = (ActionBendableHardConstraintMatch)action;
        Assert.assertEquals((long)1L, (long)actionHardConstraintMatch.getPosition());
        Assert.assertEquals((Object)"-1", (Object)actionHardConstraintMatch.getConstraintMatch());
    }

    @Test(expected=RuleModelDRLPersistenceException.class)
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        this.extension.unmarshal("unrecognizedString");
    }
}

