/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.List;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HardConstraintMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardConstraintMatchPersistenceExtension.class);
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addHardConstraintMatch\\(\\s*kcontext\\s*,.+\\);");

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public PluggableIAction unmarshal(String iActionString) throws RuleModelDRLPersistenceException {
        List parameters = StringUtils.splitArgumentsList((CharSequence)PersistenceExtensionUtils.unwrapParenthesis(iActionString));
        if (!parameters.isEmpty() && "kcontext".equals(parameters.get(0))) {
            if (parameters.size() == 2) {
                return new ActionHardConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(1)));
            }
            if (parameters.size() == 3) {
                try {
                    int bendableScoreLevel = Integer.parseInt((String)parameters.get(1));
                    return new ActionBendableHardConstraintMatch(bendableScoreLevel, PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(2)));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Could not parse bendable score level parameter " + (String)parameters.get(1) + " as an Integer");
                }
            }
        }
        throw new RuleModelDRLPersistenceException("Could not unmarshal action string '" + iActionString);
    }
}

