/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMediumConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableBigDecimalMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableLongMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardMediumSoftMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardSoftMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.PersistenceExtensionUtils;

@ApplicationScoped
public class MultiConstraintHardSoftMatchPersistenceExtension
implements RuleModelIActionPersistenceExtension {
    private static final Pattern CONSTRAINT_MATCH_PATTERN = Pattern.compile("scoreHolder\\.addMultiConstraintMatch\\(\\s*kcontext\\s*,.+\\);");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("new\\s+\\b(int|long|BigDecimal|java\\.math\\.BigDecimal)\\b\\s*\\[\\s*\\]\\s*\\{.*\\}");

    public boolean accept(String iActionString) {
        return CONSTRAINT_MATCH_PATTERN.matcher(iActionString).matches();
    }

    public PluggableIAction unmarshal(String iActionString) throws RuleModelDRLPersistenceException {
        List parameters = StringUtils.splitArgumentsList((CharSequence)PersistenceExtensionUtils.unwrapParenthesis(iActionString));
        if (!parameters.isEmpty() && "kcontext".equals(parameters.get(0))) {
            if (parameters.size() == 3) {
                boolean hardConstraintIsArray = false;
                String hardConstraintType = null;
                String hardConstraint = (String)parameters.get(1);
                Matcher hardConstraintMatcher = ARRAY_PATTERN.matcher(hardConstraint);
                if (hardConstraintMatcher.matches()) {
                    hardConstraintIsArray = true;
                    hardConstraintType = hardConstraintMatcher.group(1);
                }
                boolean softConstraintIsArray = false;
                String softConstraintType = null;
                String softConstraint = (String)parameters.get(2);
                Matcher softConstraintMatcher = ARRAY_PATTERN.matcher(softConstraint);
                if (softConstraintMatcher.matches()) {
                    softConstraintIsArray = true;
                    softConstraintType = softConstraintMatcher.group(1);
                }
                if (hardConstraintIsArray && softConstraintIsArray && hardConstraintType.equals(softConstraintType)) {
                    List hardConstraints = StringUtils.splitArgumentsList((CharSequence)this.unwrapCurlyBrackets(hardConstraint));
                    ArrayList<ActionBendableHardConstraintMatch> bendableHardConstraintMatches = new ArrayList<ActionBendableHardConstraintMatch>(hardConstraints.size());
                    for (int i = 0; i < hardConstraints.size(); ++i) {
                        bendableHardConstraintMatches.add(new ActionBendableHardConstraintMatch(i, PersistenceExtensionUtils.extractConstraintMatchValue((String)hardConstraints.get(i))));
                    }
                    List softConstraints = StringUtils.splitArgumentsList((CharSequence)this.unwrapCurlyBrackets(softConstraint));
                    ArrayList<ActionBendableSoftConstraintMatch> bendableSoftConstraintMatches = new ArrayList<ActionBendableSoftConstraintMatch>(softConstraints.size());
                    for (int i = 0; i < softConstraints.size(); ++i) {
                        bendableSoftConstraintMatches.add(new ActionBendableSoftConstraintMatch(i, PersistenceExtensionUtils.extractConstraintMatchValue((String)softConstraints.get(i))));
                    }
                    switch (hardConstraintType) {
                        case "int": {
                            return new ActionMultiConstraintBendableMatch(bendableHardConstraintMatches, bendableSoftConstraintMatches);
                        }
                        case "long": {
                            return new ActionMultiConstraintBendableLongMatch(bendableHardConstraintMatches, bendableSoftConstraintMatches);
                        }
                        case "BigDecimal": 
                        case "java.math.BigDecimal": {
                            return new ActionMultiConstraintBendableBigDecimalMatch(bendableHardConstraintMatches, bendableSoftConstraintMatches);
                        }
                    }
                } else if (!hardConstraintIsArray && !softConstraintIsArray) {
                    ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(1)));
                    ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(2)));
                    return new ActionMultiConstraintHardSoftMatch(hardConstraintMatch, softConstraintMatch);
                }
            }
            if (parameters.size() == 4) {
                ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(1)));
                ActionMediumConstraintMatch mediumConstraintMatch = new ActionMediumConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(2)));
                ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch(PersistenceExtensionUtils.extractConstraintMatchValue((String)parameters.get(3)));
                return new ActionMultiConstraintHardMediumSoftMatch(hardConstraintMatch, mediumConstraintMatch, softConstraintMatch);
            }
        }
        throw new RuleModelDRLPersistenceException("Could not unmarshal action string '" + iActionString);
    }

    private String unwrapCurlyBrackets(String s) {
        int start = s.indexOf(123);
        int end = s.lastIndexOf(125);
        if (start < 0 || end < 0) {
            return s;
        }
        return s.substring(start + 1, end).trim();
    }
}

