/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.SoftConstraintMatchPersistenceExtension;

public class SoftConstraintMatchPersistenceExtensionTest {
    private SoftConstraintMatchPersistenceExtension extension = new SoftConstraintMatchPersistenceExtension();

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addSoftConstraintMatch(kcontext, -1);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalSoftConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSoftConstraintMatch));
        ActionSoftConstraintMatch actionSoftConstraintMatch = (ActionSoftConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionSoftConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalActionBendableSoftConstraintMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionBendableSoftConstraintMatch));
        ActionBendableSoftConstraintMatch actionSoftConstraintMatch = (ActionBendableSoftConstraintMatch)action;
        Assert.assertEquals((long)1L, (long)actionSoftConstraintMatch.getPosition());
        Assert.assertEquals((Object)"-1", (Object)actionSoftConstraintMatch.getConstraintMatch());
    }

    @Test(expected=RuleModelDRLPersistenceException.class)
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        this.extension.unmarshal("unrecognizedString");
    }
}

