/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.Arrays;
import org.drools.workbench.models.commons.backend.rule.exception.RuleModelDRLPersistenceException;
import org.drools.workbench.models.datamodel.rule.PluggableIAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableBigDecimalMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableLongMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardMediumSoftMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardSoftMatch;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.MultiConstraintHardSoftMatchPersistenceExtension;

public class MultiConstraintMatchPersistenceExtensionTest {
    private MultiConstraintHardSoftMatchPersistenceExtension extension = new MultiConstraintHardSoftMatchPersistenceExtension();

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalActionMultiConstraintHardSoftMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardSoftMatch));
        ActionMultiConstraintHardSoftMatch actionActionMultiConstraintHardSoftMatch = (ActionMultiConstraintHardSoftMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionActionMultiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-2", (Object)actionActionMultiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintHardMediumSoftMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);";
        PluggableIAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardMediumSoftMatch));
        ActionMultiConstraintHardMediumSoftMatch actionActionMultiConstraintHardMediumSoftMatch = (ActionMultiConstraintHardMediumSoftMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-2", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionMediumConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-3", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintBendableMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});";
        PluggableIAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableMatch expectedAction = new ActionMultiConstraintBendableMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1"), new ActionBendableHardConstraintMatch(1, "-2")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3"), new ActionBendableSoftConstraintMatch(1, "-4")));
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableLongMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});";
        PluggableIAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableLongMatch expectedAction = new ActionMultiConstraintBendableLongMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1l"), new ActionBendableHardConstraintMatch(1, "-2l")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3l"), new ActionBendableSoftConstraintMatch(1, "-4l")));
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableBigDecimalMatch() throws RuleModelDRLPersistenceException {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});";
        PluggableIAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableBigDecimalMatch expectedAction = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "new java.math.BigDecimal(-1)"), new ActionBendableHardConstraintMatch(1, "new java.math.BigDecimal(-2)")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "new java.math.BigDecimal(-3)"), new ActionBendableSoftConstraintMatch(1, "new java.math.BigDecimal(-4)")));
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test(expected=RuleModelDRLPersistenceException.class)
    public void unmarshalUnrecognizedString() throws RuleModelDRLPersistenceException {
        this.extension.unmarshal("unrecognizedString");
    }
}

