/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ConstraintMatchInputWidget;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ConstraintMatchInputWidgetBlurHandler;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConstraintMatchInputWidgetBlurHandlerTest {
    ConstraintMatchInputWidgetBlurHandler handler;
    @Mock
    ConstraintMatchInputWidget widget;

    @Before
    public void setUp() throws Exception {
        this.handler = new ConstraintMatchInputWidgetBlurHandler(this.widget);
    }

    @Test
    public void testNullConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn(null);
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).showEmptyValuesNotAllowedError();
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void testEmptyConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).showEmptyValuesNotAllowedError();
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void testJustWhiteSpaceConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)" ");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).showEmptyValuesNotAllowedError();
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void testNumberConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"123");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).showEmptyValuesNotAllowedError();
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).clearError();
    }

    @Test
    public void testExpressionConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"$person.getAge()");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).showEmptyValuesNotAllowedError();
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).clearError();
    }
}

