/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScoreHolder;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScoreHolder;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScoreHolder;
import org.optaplanner.core.api.score.buildin.simple.SimpleScoreHolder;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScoreHolder;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScoreHolder;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ConstraintMatchInputWidget;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ConstraintMatchInputWidgetBlurHandler;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConstraintMatchInputWidgetBlurHandlerTest {
    @Mock
    private ConstraintMatchInputWidget widget;
    @Mock
    private TranslationService translationService;
    private ConstraintMatchInputWidgetBlurHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new ConstraintMatchInputWidgetBlurHandler(this.widget, this.translationService, HardSoftScoreHolder.class.getName());
    }

    @Test
    public void nullConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn(null);
        Mockito.when((Object)this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.EmptyValuesAreNotAllowedForModifyScore")).thenReturn((Object)"translation");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).showError("translation");
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void emptyConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"");
        Mockito.when((Object)this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.EmptyValuesAreNotAllowedForModifyScore")).thenReturn((Object)"translation");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).showError("translation");
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void whiteSpaceConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)" ");
        Mockito.when((Object)this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.EmptyValuesAreNotAllowedForModifyScore")).thenReturn((Object)"translation");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).showError("translation");
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void numberConstraintMatch() throws Exception {
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"123");
        this.handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).showError(Mockito.anyString());
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).clearError();
    }

    @Test
    public void validNumericValueConstraintMatchBendableScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(BendableScoreHolder.class.getName(), "-1");
    }

    @Test
    public void validNumericValueConstraintMatchBendableScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(BendableScoreHolder.class.getName(), " 1 ");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleScoreHolder.class.getName(), "-1");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleScoreHolder.class.getName(), " 1 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftScoreHolder.class.getName(), "-1");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftScoreHolder.class.getName(), " 1 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardMediumSoftScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardMediumSoftScoreHolder.class.getName(), "-1");
    }

    @Test
    public void validNumericValueConstraintMatchHardMediumSoftScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardMediumSoftScoreHolder.class.getName(), " 1 ");
    }

    @Test
    public void validNumericValueConstraintMatchBendableLongScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(BendableLongScoreHolder.class.getName(), "-9999999999");
    }

    @Test
    public void validNumericValueConstraintMatchBendableLongScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(BendableLongScoreHolder.class.getName(), " 9999999999 ");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleLongScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleLongScoreHolder.class.getName(), "-9999999999");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleLongScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleLongScoreHolder.class.getName(), " 9999999999 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftLongScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftLongScoreHolder.class.getName(), "-9999999999");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftLongScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftLongScoreHolder.class.getName(), " 9999999999 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardMediumSoftLongScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardMediumSoftLongScoreHolder.class.getName(), "-9999999999");
    }

    @Test
    public void validNumericValueConstraintMatchHardMediumSoftLongScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardMediumSoftLongScoreHolder.class.getName(), " 9999999999 ");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleDoubleScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleDoubleScoreHolder.class.getName(), "-3.14");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleDoubleScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleDoubleScoreHolder.class.getName(), " 3.14 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftDoubleScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftDoubleScoreHolder.class.getName(), "-3.14");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftDoubleScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftDoubleScoreHolder.class.getName(), " 3.14 ");
    }

    @Test
    public void validNumericValueConstraintMatchBendableBigDecimalScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(BendableBigDecimalScoreHolder.class.getName(), "-5.599");
    }

    @Test
    public void validNumericValueConstraintMatchBendableBigDecimalScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(BendableBigDecimalScoreHolder.class.getName(), " 5.599 ");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleBigDecimalScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleBigDecimalScoreHolder.class.getName(), "-5.599");
    }

    @Test
    public void validNumericValueConstraintMatchSimpleBigDecimalScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(SimpleBigDecimalScoreHolder.class.getName(), " 5.599 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftBigDecimalScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftBigDecimalScoreHolder.class.getName(), "-5.599");
    }

    @Test
    public void validNumericValueConstraintMatchHardSoftBigDecimalScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardSoftBigDecimalScoreHolder.class.getName(), " 5.599 ");
    }

    @Test
    public void validNumericValueConstraintMatchHardMediumSoftBigDecimalScoreHolder() throws Exception {
        this.testValidNumericValueConstraintMatch(HardMediumSoftBigDecimalScoreHolder.class.getName(), "-5.599");
    }

    @Test
    public void validNumericValueConstraintMatchHardMediumSoftBigDecimalScoreHolderWhiteSpace() throws Exception {
        this.testValidNumericValueConstraintMatch(HardMediumSoftBigDecimalScoreHolder.class.getName(), " 5.599 ");
    }

    private void testValidNumericValueConstraintMatch(String scoreHolderClass, String constraintMatchValue) throws Exception {
        ConstraintMatchInputWidgetBlurHandler handler = new ConstraintMatchInputWidgetBlurHandler(this.widget, this.translationService, scoreHolderClass);
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)constraintMatchValue);
        Mockito.when((Object)this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.IntegerValueParsingError")).thenReturn((Object)"translation");
        handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).showError("translation");
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).clearError();
    }

    @Test
    public void invalidValueConstraintMatchBendableScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(BendableScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchSimpleScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(SimpleScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardSoftScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardSoftScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardMediumSoftScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardMediumSoftScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchBendableLongScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(BendableLongScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchSimpleLongScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(SimpleLongScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardSoftLongScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardSoftLongScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardMediumSoftLongScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardMediumSoftLongScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchSimpleDoubleScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(SimpleDoubleScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardSoftDoubleScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardSoftDoubleScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchBendableBigDecimalScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(BendableBigDecimalScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchSimpleBigDecimalScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(SimpleBigDecimalScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardSoftBigDecimalScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardSoftBigDecimalScoreHolder.class.getName());
    }

    @Test
    public void invalidValueConstraintMatchHardMediumSoftBigDecimalScoreHolder() throws Exception {
        this.testInvalidValueConstraintMatch(HardMediumSoftBigDecimalScoreHolder.class.getName());
    }

    private void testInvalidValueConstraintMatch(String scoreHolderClass) {
        ConstraintMatchInputWidgetBlurHandler handler = new ConstraintMatchInputWidgetBlurHandler(this.widget, this.translationService, scoreHolderClass);
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"123zzz");
        Mockito.when((Object)this.translationService.getTranslation(Mockito.anyString())).thenReturn((Object)"translation");
        handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.times((int)1))).showError("translation");
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).clearError();
    }

    @Test
    public void validExpressionConstraintMatchBendableScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(BendableScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchSimpleScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(SimpleScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardSoftScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardSoftScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardMediumSoftScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardMediumSoftScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchBendableLongScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(BendableLongScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchSimpleLongScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(SimpleLongScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardSoftLongScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardSoftLongScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardMediumSoftLongScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardMediumSoftLongScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchSimpleDoubleScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(SimpleDoubleScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardSoftDoubleScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardSoftDoubleScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchBendableBigDecimalScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(BendableBigDecimalScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchSimpleBigDecimalScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(SimpleBigDecimalScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardSoftBigDecimalScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardSoftBigDecimalScoreHolder.class.getName());
    }

    @Test
    public void validExpressionConstraintMatchHardMediumSoftBigDecimalScoreHolder() throws Exception {
        this.testValidExpressionConstraintMatch(HardMediumSoftBigDecimalScoreHolder.class.getName());
    }

    private void testValidExpressionConstraintMatch(String scoreHolderClass) throws Exception {
        ConstraintMatchInputWidgetBlurHandler handler = new ConstraintMatchInputWidgetBlurHandler(this.widget, this.translationService, scoreHolderClass);
        Mockito.when((Object)this.widget.getConstraintMatchValue()).thenReturn((Object)"$person.getAge()");
        handler.onBlur((BlurEvent)Mockito.mock(BlurEvent.class));
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget, (VerificationMode)Mockito.never())).showError(Mockito.anyString());
        ((ConstraintMatchInputWidget)Mockito.verify((Object)this.widget)).clearError();
    }
}

