/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.client.plugin;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashMap;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.core.api.score.buildin.simple.SimpleScoreHolder;
import org.optaplanner.workbench.models.datamodel.rule.AbstractActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.screens.guidedrule.client.plugin.ActionPluginClientService;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ScoreHolderGlobalAware;
import org.optaplanner.workbench.screens.guidedrule.model.BendableScoreLevelsWrapper;
import org.optaplanner.workbench.screens.guidedrule.model.ScoreInformation;
import org.optaplanner.workbench.screens.guidedrule.service.ScoreHolderService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionPluginClientServiceTest {
    @Mock
    private ScoreHolderService scoreHolderService;
    @Mock
    private TranslationService translationService;
    private ActionPluginClientService service;

    @Before
    public void setUp() {
        this.service = new ActionPluginClientService((Caller)new CallerMock((Object)this.scoreHolderService), this.translationService);
    }

    @Test
    public void invokeScoreInformationCachedOperationCacheEmpty() {
        HashMap serviceCache = new HashMap();
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        this.service.invokeScoreInformationCachedOperation(ruleModeller, scoreInformation -> {});
        ((ScoreHolderService)Mockito.verify((Object)this.scoreHolderService, (VerificationMode)Mockito.times((int)1))).getProjectScoreInformation((Path)Matchers.any());
    }

    @Test
    public void invokeScoreInformationCachedOperationCacheNotEmpty() {
        HashMap<String, ScoreInformation> serviceCache = new HashMap<String, ScoreInformation>();
        serviceCache.put(ActionPluginClientService.SCORE_INFORMATION, new ScoreInformation());
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        this.service.invokeScoreInformationCachedOperation(ruleModeller, scoreInformation -> {});
        ((ScoreHolderService)Mockito.verify((Object)this.scoreHolderService, (VerificationMode)Mockito.never())).getProjectScoreInformation((Path)Matchers.any(Path.class));
    }

    @Test
    public void initScoreHolderAwarePlugin() {
        ScoreInformation scoreInformation = new ScoreInformation(Arrays.asList(HardSoftScoreHolder.class.getName()), Arrays.asList(new BendableScoreLevelsWrapper(1, 1)));
        HashMap<String, ScoreInformation> serviceCache = new HashMap<String, ScoreInformation>();
        serviceCache.put(ActionPluginClientService.SCORE_INFORMATION, scoreInformation);
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        ScoreHolderGlobalAware scoreHolderGlobalAware = (ScoreHolderGlobalAware)Mockito.mock(ScoreHolderGlobalAware.class);
        this.service.initScoreHolderAwarePlugin(ruleModeller, scoreHolderGlobalAware, Arrays.asList(HardSoftScoreHolder.class.getName()));
        ((ScoreHolderGlobalAware)Mockito.verify((Object)scoreHolderGlobalAware, (VerificationMode)Mockito.times((int)1))).scoreHolderGlobalLoadedCorrectly(HardSoftScoreHolder.class.getName());
    }

    @Test
    public void initScoreHolderAwarePluginAmbigiousScoreHolder() {
        ScoreInformation scoreInformation = new ScoreInformation(Arrays.asList(HardSoftScoreHolder.class.getName(), SimpleScoreHolder.class.getName()), Arrays.asList(new BendableScoreLevelsWrapper(1, 1)));
        HashMap<String, ScoreInformation> serviceCache = new HashMap<String, ScoreInformation>();
        serviceCache.put(ActionPluginClientService.SCORE_INFORMATION, scoreInformation);
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        ScoreHolderGlobalAware scoreHolderGlobalAware = (ScoreHolderGlobalAware)Mockito.mock(ScoreHolderGlobalAware.class);
        this.service.initScoreHolderAwarePlugin(ruleModeller, scoreHolderGlobalAware, Arrays.asList(HardSoftScoreHolder.class.getName()));
        ((ScoreHolderGlobalAware)Mockito.verify((Object)scoreHolderGlobalAware, (VerificationMode)Mockito.times((int)1))).scoreHolderGlobalIssueDetected((String)Matchers.any());
    }

    @Test
    public void addPluginToActionList() {
        ScoreInformation scoreInformation = new ScoreInformation(Arrays.asList(HardSoftScoreHolder.class.getName()), Arrays.asList(new BendableScoreLevelsWrapper(1, 1)));
        HashMap<String, ScoreInformation> serviceCache = new HashMap<String, ScoreInformation>();
        serviceCache.put(ActionPluginClientService.SCORE_INFORMATION, scoreInformation);
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        Command addCommand = (Command)Mockito.mock(Command.class);
        this.service.addPluginToActionList(ruleModeller, addCommand, Arrays.asList(HardSoftScoreHolder.class.getName()));
        ((Command)Mockito.verify((Object)addCommand, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void addPluginToActionListAmbigiousScoreHolder() {
        ScoreInformation scoreInformation = new ScoreInformation(Arrays.asList(HardSoftScoreHolder.class.getName(), SimpleScoreHolder.class.getName()), Arrays.asList(new BendableScoreLevelsWrapper(1, 1)));
        HashMap<String, ScoreInformation> serviceCache = new HashMap<String, ScoreInformation>();
        serviceCache.put(ActionPluginClientService.SCORE_INFORMATION, scoreInformation);
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        Command addCommand = (Command)Mockito.mock(Command.class);
        this.service.addPluginToActionList(ruleModeller, addCommand, Arrays.asList(HardSoftScoreHolder.class.getName()));
        ((Command)Mockito.verify((Object)addCommand, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void initBendableScoreLevels() {
        ScoreInformation scoreInformation = new ScoreInformation(Arrays.asList(HardSoftScoreHolder.class.getName()), Arrays.asList(new BendableScoreLevelsWrapper(1, 2)));
        HashMap<String, ScoreInformation> serviceCache = new HashMap<String, ScoreInformation>();
        serviceCache.put(ActionPluginClientService.SCORE_INFORMATION, scoreInformation);
        RuleModeller ruleModeller = (RuleModeller)Mockito.mock(RuleModeller.class);
        Mockito.when((Object)ruleModeller.getServiceInvocationCache()).thenReturn(serviceCache);
        ActionMultiConstraintBendableMatch constraintMatch = new ActionMultiConstraintBendableMatch();
        this.service.initBendableScoreLevels(ruleModeller, (AbstractActionMultiConstraintBendableMatch)constraintMatch);
        Assert.assertEquals((long)1L, (long)constraintMatch.getActionBendableHardConstraintMatches().size());
        Assert.assertEquals((long)2L, (long)constraintMatch.getActionBendableSoftConstraintMatches().size());
    }
}

