/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.workbench.screens.solver.model.ScoreDefinitionTypeModel;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;

class ToSolverConfigModel {
    private SolverConfig solverConfig;

    public ToSolverConfigModel(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public SolverConfigModel get() {
        SolverConfigModel model = new SolverConfigModel();
        model.setTerminationConfig(this.create(this.solverConfig.getTerminationConfig()));
        model.setScoreDirectorFactoryConfig(this.create(this.solverConfig.getScoreDirectorFactoryConfig()));
        return model;
    }

    private ScoreDirectorFactoryConfigModel create(ScoreDirectorFactoryConfig scoreDirectorFactoryConfig) {
        if (scoreDirectorFactoryConfig == null) {
            return new ScoreDirectorFactoryConfigModel();
        }
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        model.setScoreDefinitionType(this.create(scoreDirectorFactoryConfig.getScoreDefinitionType()));
        model.setKSessionName(scoreDirectorFactoryConfig.getKsessionName());
        return model;
    }

    private ScoreDefinitionTypeModel create(ScoreDefinitionType scoreDefinitionType) {
        if (scoreDefinitionType != null) {
            for (ScoreDefinitionTypeModel model : ScoreDefinitionTypeModel.values()) {
                if (!model.name().equals(scoreDefinitionType.name())) continue;
                return model;
            }
        }
        return null;
    }

    private TerminationConfigModel create(TerminationConfig terminationConfig) {
        if (terminationConfig == null) {
            return new TerminationConfigModel();
        }
        TerminationConfigModel model = new TerminationConfigModel();
        model.setDaysSpentLimit(terminationConfig.getDaysSpentLimit());
        model.setHoursSpentLimit(terminationConfig.getHoursSpentLimit());
        model.setMinutesSpentLimit(terminationConfig.getMinutesSpentLimit());
        model.setSecondsSpentLimit(terminationConfig.getSecondsSpentLimit());
        model.setMillisecondsSpentLimit(terminationConfig.getMillisecondsSpentLimit());
        model.setUnimprovedDaysSpentLimit(terminationConfig.getUnimprovedDaysSpentLimit());
        model.setUnimprovedHoursSpentLimit(terminationConfig.getUnimprovedHoursSpentLimit());
        model.setUnimprovedMinutesSpentLimit(terminationConfig.getUnimprovedMinutesSpentLimit());
        model.setUnimprovedSecondsSpentLimit(terminationConfig.getUnimprovedSecondsSpentLimit());
        model.setUnimprovedMillisecondsSpentLimit(terminationConfig.getUnimprovedMillisecondsSpentLimit());
        return model;
    }
}

