/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.optaplanner.workbench.screens.solver.type.SolverResourceTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class SolverFileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(SolverFileIndexer.class);
    @Inject
    private KieProjectService kieProjectService;
    @Inject
    private SolverResourceTypeDefinition solverResourceTypeDefinition;

    protected DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
        KieProject project = (KieProject)this.kieProjectService.resolveProject(vfsPath);
        if (project == null) {
            logger.error("Unable to index " + path.toUri() + ", project could not be resolved.");
            return null;
        }
        Package _package = this.kieProjectService.resolvePackage(vfsPath);
        if (_package == null) {
            logger.error("Unable to index " + path.toUri() + ", package could not be resolved.");
            return null;
        }
        return new DefaultIndexBuilder(vfsPath.getFileName(), (Project)project, _package);
    }

    public boolean supportsPath(Path path) {
        return this.solverResourceTypeDefinition.accept(Paths.convert((Path)path));
    }
}

